!=======================================================================
      subroutine getHV(n,nx,ny,nb,nBC,level,ierr,
     &       gammaT,htsq,hx,hy, A1,A2,H,V)
!=======================================================================
      implicit none
      integer n,nx,ny,nb,nBC,level,ierr
      real*8  gammaT,htsq,hx,hy
      real*8  A1(-nb:nb,0:nx,0:ny),A2(-nb:nb,0:ny,0:nx)
      real*8  H(-nb:nb,0:nx,0:ny),V(-nb:nb,0:ny,0:nx)

!---------------------
!---- local variables
!---------------------
      integer i,j,k,nxm1,nym1,level0

      level0=0
      nxm1=nx-1
      nym1=ny-1

      if(level.ge.1) print'("GET_HV:")'

!-----------------------
!--- get "H"  and "V"
!-----------------------

      do j=0,ny
      do i=0,nx
          do k=-nb,nb
              H(k,i,j)=htsq*A1(k,i,j)
          enddo
          H(0,i,j)=H(0,i,j)+gammaT
      enddo
      enddo

      do i=0,nx
      do j=0,ny
          do k=-nb,nb
              V(k,j,i)=htsq*A2(k,j,i)
          enddo
          V(0,j,i)=V(0,j,i)+gammaT
      enddo
      enddo


      if(nBC.eq.1)then
!-------------------------------------
!---- Set the Dirichlet BC
!-------------------------------------

          do j=0,ny
          do i=0,nx,nx
              do k=-nb,nb
                  H(k,i,j)=0.d0
              enddo
              H(0,i,j)=1.d0
          enddo
          enddo

          do i=0,nx
          do j=0,ny,ny
              do k=-nb,nb
                  V(k,j,i)=0.d0
              enddo
              V(0,j,i)=1.d0
          enddo
          enddo

      else if(nBC.eq.2)then
!-------------------------------------
!---- Set the Neumann BC
!-------------------------------------

          i=0
          do j=0,ny
          do k=-nb,-1
              H(-k,i,j)=H(-k,i,j)+H(k,i,j)
              H(k,i,j)=0.d0
          enddo
          enddo

          i=nx
          do j=0,ny
          do k=1,nb
              H(-k,i,j)=H(-k,i,j)+H(k,i,j)
              H(k,i,j)=0.d0
          enddo
          enddo

          !------------

          j=0
          do i=0,nx
          do k=-nb,-1
              V(-k,j,i)=V(-k,j,i)+V(k,j,i)
              V(k,j,i)=0.d0
          enddo
          enddo

          j=ny
          do i=0,nx
          do k=1,nb
              V(-k,j,i)=V(-k,j,i)+V(k,j,i)
              V(k,j,i)=0.d0
          enddo
          enddo

      endif

!-------------------------------------
!---- LU-factorization of "H" and "V"
!-------------------------------------

      do j=0,ny
          call lufac(nb,(nx+1),level0,H(-nb,0,j))
      enddo

      do i=0,nx
          call lufac(nb,(ny+1),level0,V(-nb,0,i))
      enddo


      return
      end

