!=======================================================================
      subroutine explicit(n,nt,nx,ny,nb,idnumer,level,ierr,
     &      mnxy,theta,ht,hx,hy,time,
     &      tauJ,tauK,gamma1,gamma2,gammaT,
     &      S,F,A1,A2,U2,U1,U0,Utilde,AU1,QU10,wksp)
!=======================================================================
      implicit none
      integer n,nt,nx,ny,nb,idnumer,level,ierr,mnxy
      real*8  theta,ht,hx,hy,time
      real*8  tauJ,tauK,gamma1,gamma2,gammaT
      real*8  A1(-nb:nb,0:nx,0:ny),A2(-nb:nb,0:ny,0:nx)
      real*8  S(0:nx,0:ny),F(0:nt)
      real*8  U2(0:nx,0:ny),U1(0:nx,0:ny),U0(0:nx,0:ny)
      real*8  Utilde(0:nx,0:ny),AU1(0:nx,0:ny),QU10(0:nx,0:ny)
      real*8  wksp(0:nx,0:ny)

!---------------------
!---- local variables
!---------------------

      integer ix,iy,i,k
      real*8  htsq0GT,G10twoht,G20htsq,rht

      htsq0GT=ht**2/gammaT
      G10twoht=gamma1/(2.d0*ht)
      G20htsq=gamma2/(ht*ht)
      rht=1.d0/ht

!---- Interface

      if(level.ge.1)then
          print'("EXPLICIT:",$)'
          print*,"n=",n
      endif

!============================

      call getAU(3,nx,ny,nb,level,ierr,A1,A2,U1,AU1)

      do iy=0,ny
      do ix=0,nx
          wksp(ix,iy)=U1(ix,iy)-U0(ix,iy)
      enddo
      enddo
      call getQU(nx,ny,nb,level,ierr,tauJ,tauK,A1,A2,wksp,QU10)

      do iy=0,ny
      do ix=0,nx
          U2(ix,iy)=htsq0GT*( G10twoht*U0(ix,iy) +G20htsq*Utilde(ix,iy)
     &                       -AU1(ix,iy) -rht*QU10(ix,iy) )
      enddo
      enddo

      if(idnumer.ge.1) then
          do iy=0,ny
          do ix=0,nx
              U2(ix,iy)=U2(ix,iy)+htsq0GT*S(ix,iy)
          enddo
          enddo
      endif

      return
      end

