!=======================================================================
      subroutine HeatMicro(nt,nx,ny,mnxy,nBC,nInit,
     &   idK,iOrder,idsol,nb,nwA,level,idnumer,ierr,neqn,
     &   at,bt,ax,bx,ay,by,
     &   Chat,tauJ,tauK,theta,
     &   A1,A2,H,V,E1,E2,U,Kond,S,F,G,wksp)
!=======================================================================
      implicit none
      integer nt,nx,ny,mnxy,nBC,nInit
      integer idK,iOrder,idsol,nb,nwA,level,idnumer,ierr,neqn
      real*8  at,bt,ax,bx,ay,by
      real*8  Chat,tauJ,tauK,theta
      real*8  A1(-nb:nb,0:nx,0:ny),A2(-nb:nb,0:ny,0:nx)
      real*8  H(-nb:nb,0:nx,0:ny),V(-nb:nb,0:ny,0:nx)
      real*8  E1(-nb:nb,0:nx,0:ny),E2(-nb:nb,0:ny,0:nx)
      real*8  U(0:nx,0:ny,0:2),Kond(0:nx,0:ny,2),S(0:nx,0:ny)
      real*8  F(0:nt),G(0:nx,0:ny)
      real*8  wksp(neqn,*)

!------------------------------------
!---- local variables
!------------------------------------

      integer i,j,ix,iy,k,level0,level1,levelt,id2,nb1,margin,nt_loc
      real*8 gamma1,gamma2,gammaT
      real*8  ht,hx,hy,zero,eps,ht_loc
      real*8  px,py,errmax,sol,pi,tmp
      real*4  utime0,stime0,utime1,stime1
      character*40 scheme

      real*8 pi_S
      common /c0math/ pi_S

      real*8 ax_S,bx_S,ay_S,by_S
      common /c0geom/ ax_S,bx_S,ay_S,by_S

      real*8 tauJ_S,tauK_S,gamma1_S,gamma2_S
      common /c0coef/ tauJ_S,tauK_S,gamma1_S,gamma2_S

!------------------------------------
!---- basic checking and setting
!------------------------------------

      zero=0.d0
      level0=0
      level1=min(level,1)
      eps=1.d-8
      pi=dacos(-1.d0)

!-----------------

      scheme='NONE'
      if(idsol.eq.2) scheme='3-Level LOD'

      if(scheme.eq.'NONE')then
          print*,"**** Error: HeatMicro.f: Wrong idsol"
          ierr=1
          return
      endif

      if(idnumer.ge.1)then
          tauJ=1.d0
          tauK=1.d0
          print*,"**** CHANGE: HeatMicro.f: tauJ=",tauJ
          print*,"**** CHANGE: HeatMicro.f: tauK=",tauK
      endif

!------------------

      hx=(bx-ax)/dble(nx)
      hy=(by-ay)/dble(ny)
      ht=(bt-at)/dble(nt)

      gamma1=Chat
      gamma2=Chat*tauJ
      gammaT=gamma2+0.5d0*gamma1*ht

!------------------
      pi_S=pi

      ax_S=ax
      bx_S=bx
      ay_S=ay
      by_S=by

      tauJ_S  =tauJ
      tauK_S  =tauK
      gamma1_S=gamma1
      gamma2_S=gamma2

!------------------------------------
!---- Print out information
!------------------------------------

      if(level.ge.1)then
         print'("HeatMicro: idsol=",i2,": ",a40)',idsol,scheme
      endif

      if(level.ge.2)then
         print*,"nt=",nt," at=",at," bt=",bt," ht=",ht
         print*,"nx=",nx," ax=",ax," bx=",bx," hx=",hx
         print*,"ny=",ny," ay=",ay," by=",by," hy=",hy
         print*,"nBC=",nBC," nInit=",nInit
         print*,"theta=",theta," iOrder=",iOrder," idnumer=",idnumer
         print*,"tauJ=",tauJ," tauK=",tauK
     &        ," gamma1=",gamma1," gamma2=",gamma2," gammaT=",gammaT
      endif


!-----------------------------------------------------------
!---- Read Physical Parameters: U0&G, Kond
!-----------------------------------------------------------

      call readU0G(nx,ny,nInit,level1,ierr,ax,bx,ay,by,
     &             idnumer,U(0,0,0),G)

      call getKond(nx,ny,idK,level1,ierr,ax,bx,ay,by,hx,hy,Kond)


      if(level.ge.1)then
          open(68,file="fort.U0")
          print*,"<fort.U0> contains computed solution at t=",at
          do j=0,ny
          do i=0,nx
              write(68,*) U(i,j,0)
          enddo
          enddo
          close(68)
      endif


!------------------------------------
!---- Get the Source Terms
!------------------------------------

      if(idnumer.eq.1)then
          call getS(0,nx,ny,nb,level1,ierr,at,ht,theta,
     &              ax,bx,ay,by,S)
      else
          do iy=0,ny
          do ix=0,nx
              S(ix,iy)=0.d0
          enddo
          enddo
      endif

      do k=0,nt
          F(k)=0.d0
      enddo

      if(ierr.ne.0) return
      call etimef77(utime0,stime0)

!------------------------------------
!---- Get initial values "U1"
!------------------------------------

      nb1=1

      call mtx35Diff(3,nx,ny,nb1,level1,ierr,ax,bx,ay,by,Kond,A1,A2)

      call getU1(nx,ny,nt,nb1,nBC,idnumer,level1,ierr,
     &           tauJ,tauK,gamma1,gamma2,gammaT,
     &           ax,bx,ay,by,1.d0,theta, at,ht,hx,hy,
     &           F,S,G,A1,A2,U,wksp,wksp(1,4))

      if(ierr.ne.0) return

!------------------------------------
!---- get "A1, A2" and "E1, E2"
!------------------------------------

      if(nb.ne.nb1)then
          call mtx35Diff(3,nx,ny,nb,level1,ierr,ax,bx,ay,by,Kond,A1,A2)
          if(ierr.ne.0) return
      endif

      call getE1E2(nx,ny,nb,level1,ierr,theta,ht,tauJ,tauK,A1,A2,E1,E2)


!------------------------------------
!---- Call Solvers
!------------------------------------
 1000 continue

      if(idsol.eq.2)then

          call sol_LOD(nt,nx,ny,idsol,nb,nwA,nBC,level,ierr,
     &        tauJ,tauK,gamma1,gamma2,gammaT,
     &        at,bt,ax,bx,ay,by,theta,
     &        mnxy,idnumer,id2, ht,hx,hy,scheme,
     &        A1,A2,H,V,E1,E2,U,S,F,wksp(1,1),wksp(1,2))

      else

          print*,"**** Error: HeatMicro.f: Wrong idsol!!"
          ierr=1
          return

      endif


!------------------------------------
!---- Print out the results
!------------------------------------

      if(level.le.0) return

      print'(40("-"))'
      call etimef77(utime1,stime1)
      print'("Elapsed Time=",f7.2)',utime1-utime0

      print'(" scheme=",a15," theta=",f6.2)',
     &         scheme,theta
      print'(" nt=",i4," at=",f6.2," bt=",f6.2," ht=",f8.4)',nt,at,bt,ht
      print'(" nx=",i4," ax=",f6.2," bx=",f6.2," hx=",f8.4)',nx,ax,bx,hx
      print'(" ny=",i4," ay=",f6.2," by=",f6.2," hy=",f8.4)',ny,ay,by,hy

      if(idnumer.eq.1 .and. level.ge.1)then
          margin=3
          errmax=0.d0
          do iy=margin,ny-margin
             py=ay+hy*dble(iy)
          do ix=margin,nx-margin
             px=ax+hx*dble(ix)
             tmp=sol(bt,px,py)
             errmax=max(errmax,dabs(U(ix,iy,id2)-tmp))
          enddo
          enddo
          print'(" L8Err (t=",f5.2,")= ",1pe8.2)',bt,errmax
      endif


      open(1,file="fort.0")
         write(1,*) scheme
      close(1)

      open(1,file="fort.1")
      write(1,*) nx+1,ax,bx,hx,ny+1,ay,by,hy
      close(1)

      open(2,file="fort.2")
         write(2,*) nt,at,bt,ht,theta
      close(2)

      open(68,file="fort.Un")
      print*,"<fort.Un> contains computed solution at t=",bt
      do j=0,ny
      do i=0,nx
          write(68,*) U(i,j,id2)
      enddo
      enddo
      close(68)


      return
      end
