!=======================================================================
      subroutine update1(idr,nx,ny,nz,ix,iy,iz, dx,dy,dz,idTT,TT,vel)
!=======================================================================
!--- This routine updates "TT(ix,iy,iz)".
      implicit none
      integer idr,nx,ny,nz,ix,iy,iz
      real*8  dx,dy,dz
      integer idTT(0:nx,0:ny,0:nz)
      real*8  TT(0:nx,0:ny,0:nz),vel(0:nx,0:ny,0:nz)
      real*8  angx,angy,angz
      common  /c4angle/ angx,angy,angz

      real*8  taux,tauy,tauz
      real*8  averslow,slow2,ham

      goto(10,20,30,40,50,60),idr

 10   continue

!--- Update from "West"

         call eno1(0,1,1,nx,ny,nz,ix-1,iy,iz,
     &      dx,dy,dz,taux,tauy,tauz,idTT,TT)
         slow2=(averslow(vel(ix-1,iy,iz),vel(ix,iy,iz)))**2
         ham=dsqrt(max(angx*slow2,slow2-tauy**2-tauz**2))
         TT(ix,iy,iz)=min(TT(ix,iy,iz),TT(ix-1,iy,iz)+dx*ham)

      return
 20   continue

!--- Update from "East"

         call eno1(0,1,1,nx,ny,nz,ix+1,iy,iz,
     &      dx,dy,dz,taux,tauy,tauz,idTT,TT)
         slow2=(averslow(vel(ix+1,iy,iz),vel(ix,iy,iz)))**2
         ham=dsqrt(max(angx*slow2,slow2-tauy**2-tauz**2))
         TT(ix,iy,iz)=min(TT(ix,iy,iz),TT(ix+1,iy,iz)+dx*ham)

      return
 30   continue

!--- Update from "South"

         call eno1(1,0,1,nx,ny,nz,ix,iy-1,iz,
     &      dx,dy,dz,taux,tauy,tauz,idTT,TT)
         slow2=(averslow(vel(ix,iy-1,iz),vel(ix,iy,iz)))**2
         ham=dsqrt(max(angy*slow2,slow2-taux**2-tauz**2))
         TT(ix,iy,iz)=min(TT(ix,iy,iz),TT(ix,iy-1,iz)+dy*ham)

      return
 40   continue

!--- Update from "North"

         call eno1(1,0,1,nx,ny,nz,ix,iy+1,iz,
     &      dx,dy,dz,taux,tauy,tauz,idTT,TT)
         slow2=(averslow(vel(ix,iy+1,iz),vel(ix,iy,iz)))**2
         ham=dsqrt(max(angy*slow2,slow2-taux**2-tauz**2))
         TT(ix,iy,iz)=min(TT(ix,iy,iz),TT(ix,iy+1,iz)+dy*ham)

      return
 50   continue

!--- Update from "Bottom"

         call eno1(1,1,0,nx,ny,nz,ix,iy,iz-1,
     &      dx,dy,dz,taux,tauy,tauz,idTT,TT)
         slow2=(averslow(vel(ix,iy,iz-1),vel(ix,iy,iz)))**2
         ham=dsqrt(max(angz*slow2,slow2-taux**2-tauy**2))
         TT(ix,iy,iz)=min(TT(ix,iy,iz),TT(ix,iy,iz-1)+dz*ham)

      return
 60   continue

!--- Update from "Top"

         call eno1(1,1,0,nx,ny,nz,ix,iy,iz+1,
     &      dx,dy,dz,taux,tauy,tauz,idTT,TT)
         slow2=(averslow(vel(ix,iy,iz+1),vel(ix,iy,iz)))**2
         ham=dsqrt(max(angz*slow2,slow2-taux**2-tauy**2))
         TT(ix,iy,iz)=min(TT(ix,iy,iz),TT(ix,iy,iz+1)+dz*ham)


      return
      end

