!=======================================================================
      subroutine ttFMM(nx,ny,nz,MT1,lastGA,maxGA,level,ierr,
     &    dx,dy,dz, idTT,GA,TT,vel,wksp)
!=======================================================================
      implicit none
      integer nx,ny,nz,MT1,lastGA,maxGA,level,ierr
      real*8  dx,dy,dz
      integer idTT(0:nx,0:ny,0:nz),GA(3,*)
      real*8  TT(0:nx,0:ny,0:nz),vel(0:nx,0:ny,0:nz),wksp(*)

      integer i,j

      if(level.ge.1) print'("TT_FMM:")'
      if(level.ge.2) print*,"nx=",nx," ny=",ny," nz=",nz,"  MT1=",MT1

!------------------------------------
!--- The FMM marching
!------------------------------------

      do while (MT1.ge.2)

         call fmm1(nx,ny,nz,MT1,lastGA,maxGA,level,ierr,
     &         dx,dy,dz, idTT,GA,TT,vel)

         if(level.ge.4) print*,"MT1=",MT1," maxGA=",maxGA

      enddo


      return
      end


!=======================================================================
      subroutine fmm1(nx,ny,nz,MT1,lastGA,maxGA,level,ierr, 
     &      dx,dy,dz, idTT,GA,TT,vel)
!=======================================================================
      implicit none
      integer nx,ny,nz,MT1,lastGA,maxGA,level,ierr
      real*8  dx,dy,dz
      integer idTT(0:nx,0:ny,0:nz),GA(3,*)
      real*8  TT(0:nx,0:ny,0:nz),vel(0:nx,0:ny,0:nz)

      integer i,IN,ix,iy,iz,idTTsv,idr,level0
      real*8  TT0,TTsave

      level0=0
      idr=0

      ix=GA(1,1)
      iy=GA(2,1)
      iz=GA(3,1)

      TT0=TT(ix,iy,iz)
      idTT(ix,iy,iz)=2

      if(level.ge.4) print*,"ix,iy,iz=",ix,iy,iz

      call heapDown(nx,ny,nz,MT1,lastGA,maxGA,level0,ierr, GA,TT)


!--- Update "West"

      if(ix.ne.0)then
         idTTsv=idTT(ix-1,iy,iz)
         TTsave=  TT(ix-1,iy,iz)
         if(idTTsv.le.1 .and. TTsave.gt.TT0)then

            call sethian(idr,nx,ny,nz,ix-1,iy,iz, dx,dy,dz,idTT,TT,vel)

            if(idTTsv.eq.1)then
               if(TT(ix-1,iy,iz).lt.TTsave)then
                  call search(ix-1,iy,iz,IN,maxGA,GA)
                  call heapUp(1,nx,ny,nz,IN,maxGA,level0,ierr, GA,TT)
               endif
            else if(idTTsv.eq.0)then
               GA(1,MT1)=ix-1
               GA(2,MT1)=iy
               GA(3,MT1)=iz
               idTT(ix-1,iy,iz)=1
               call heapUp(1,nx,ny,nz,MT1,maxGA,level0,ierr, GA,TT)
               do while (GA(1,MT1).ge.0)
                  MT1=MT1+1
               enddo
               lastGA=max(lastGA,MT1-1)
            endif

         endif
      endif


!--- Update "East"

      if(ix.ne.nx)then
         idTTsv=idTT(ix+1,iy,iz)
         TTsave=  TT(ix+1,iy,iz)
         if(idTTsv.le.1 .and. TTsave.gt.TT0)then

            call sethian(idr,nx,ny,nz,ix+1,iy,iz, dx,dy,dz,idTT,TT,vel)

            if(idTTsv.eq.1)then
               if(TT(ix+1,iy,iz).lt.TTsave)then
                  call search(ix+1,iy,iz,IN,maxGA,GA)
                  call heapUp(1,nx,ny,nz,IN,maxGA,level0,ierr, GA,TT)
               endif
            else if(idTTsv.eq.0)then
               GA(1,MT1)=ix+1
               GA(2,MT1)=iy
               GA(3,MT1)=iz
               idTT(ix+1,iy,iz)=1
               call heapUp(1,nx,ny,nz,MT1,maxGA,level0,ierr, GA,TT)
               do while (GA(1,MT1).ge.0)
                  MT1=MT1+1
               enddo
               lastGA=max(lastGA,MT1-1)
            endif

         endif
      endif


!--- Update "South"

      if(iy.ne.0)then
         idTTsv=idTT(ix,iy-1,iz)
         TTsave=  TT(ix,iy-1,iz)
         if(idTTsv.le.1 .and. TTsave.gt.TT0)then

            call sethian(idr,nx,ny,nz,ix,iy-1,iz, dx,dy,dz,idTT,TT,vel)

            if(idTTsv.eq.1)then
               if(TT(ix,iy-1,iz).lt.TTsave)then
                  call search(ix,iy-1,iz,IN,maxGA,GA)
                  call heapUp(1,nx,ny,nz,IN,maxGA,level0,ierr, GA,TT)
               endif
            else if(idTTsv.eq.0)then
               GA(1,MT1)=ix
               GA(2,MT1)=iy-1
               GA(3,MT1)=iz
               idTT(ix,iy-1,iz)=1
               call heapUp(1,nx,ny,nz,MT1,maxGA,level0,ierr, GA,TT)
               do while (GA(1,MT1).ge.0)
                  MT1=MT1+1
               enddo
               lastGA=max(lastGA,MT1-1)
            endif

         endif
      endif


!--- Update "North"

      if(iy.ne.ny)then
         idTTsv=idTT(ix,iy+1,iz)
         TTsave=  TT(ix,iy+1,iz)
         if(idTTsv.le.1 .and. TTsave.gt.TT0)then

            call sethian(idr,nx,ny,nz,ix,iy+1,iz, dx,dy,dz,idTT,TT,vel)

            if(idTTsv.eq.1)then
               if(TT(ix,iy+1,iz).lt.TTsave)then
                  call search(ix,iy+1,iz,IN,maxGA,GA)
                  call heapUp(1,nx,ny,nz,IN,maxGA,level0,ierr, GA,TT)
               endif
            else if(idTTsv.eq.0)then
               GA(1,MT1)=ix
               GA(2,MT1)=iy+1
               GA(3,MT1)=iz
               idTT(ix,iy+1,iz)=1
               call heapUp(1,nx,ny,nz,MT1,maxGA,level0,ierr, GA,TT)
               do while (GA(1,MT1).ge.0)
                  MT1=MT1+1
               enddo
               lastGA=max(lastGA,MT1-1)
            endif

         endif
      endif


      if(nz.eq.0)then
      else

!--- Update "Bottom"

      if(iz.ne.0)then
         idTTsv=idTT(ix,iy,iz-1)
         TTsave=  TT(ix,iy,iz-1)
         if(idTTsv.le.1 .and. TTsave.gt.TT0)then

            call sethian(idr,nx,ny,nz,ix,iy,iz-1, dx,dy,dz,idTT,TT,vel)

            if(idTTsv.eq.1)then
               if(TT(ix,iy,iz-1).lt.TTsave)then
                  call search(ix,iy,iz-1,IN,maxGA,GA)
                  call heapUp(1,nx,ny,nz,IN,maxGA,level0,ierr, GA,TT)
               endif
            else if(idTTsv.eq.0)then
               GA(1,MT1)=ix
               GA(2,MT1)=iy
               GA(3,MT1)=iz-1
               idTT(ix,iy,iz-1)=1
               call heapUp(1,nx,ny,nz,MT1,maxGA,level0,ierr, GA,TT)
               do while (GA(1,MT1).ge.0)
                  MT1=MT1+1
               enddo
               lastGA=max(lastGA,MT1-1)
            endif

         endif
      endif


!--- Update "Top"

      if(iz.ne.nz)then
         idTTsv=idTT(ix,iy,iz+1)
         TTsave=  TT(ix,iy,iz+1)
         if(idTTsv.le.1 .and. TTsave.gt.TT0)then

            call sethian(idr,nx,ny,nz,ix,iy,iz+1, dx,dy,dz,idTT,TT,vel)

            if(idTTsv.eq.1)then
               if(TT(ix,iy,iz+1).lt.TTsave)then
                  call search(ix,iy,iz+1,IN,maxGA,GA)
                  call heapUp(1,nx,ny,nz,IN,maxGA,level0,ierr, GA,TT)
               endif
            else if(idTTsv.eq.0)then
               GA(1,MT1)=ix
               GA(2,MT1)=iy
               GA(3,MT1)=iz+1
               idTT(ix,iy,iz+1)=1
               call heapUp(1,nx,ny,nz,MT1,maxGA,level0,ierr, GA,TT)
               do while (GA(1,MT1).ge.0)
                  MT1=MT1+1
               enddo
               lastGA=max(lastGA,MT1-1)
            endif

         endif
      endif

      endif

      return
      end

