!=======================================================================
      subroutine skimSeth(idr,nx,ny,nz,ix,iy,iz, dx,dy,dz,idTT,TT,vel)
!=======================================================================
!--- This routine updates "TT(ix,iy,iz)".
      implicit none
      integer idr,nx,ny,nz,ix,iy,iz
      real*8  dx,dy,dz
      integer idTT(0:nx,0:ny,0:nz)
      real*8  TT(0:nx,0:ny,0:nz),vel(0:nx,0:ny,0:nz)
      integer idSlow
      common  /c4Slow/ idSlow

      integer ix0,iy0,iz0
      real*8  v0,v1,rT
      real*8  averslow,renew,slow2,zero

      zero=0.d0

      v0=vel(ix,iy,iz)
      if(idSlow.eq.0) slow2=(1.d0/v0)**2

      if(nz.eq.0)then
         dz=zero
         goto(210,210,230,230),idr
      else
         goto(10,10,30,30,50,50),idr
      endif

 10   continue
!--- Update from "West" or "East"

      if (idr.eq.1) then
         ix0=ix-1
      else
         ix0=ix+1
      endif

      if(idSlow.eq.1)then
         v1=vel(ix0,iy,iz)
         slow2=(averslow(v0,v1))**2
      endif

      if(iy.ne.0 .and. iz.ne.0)then
         rT=renew(idTT(ix0,iy,iz),idTT(ix,iy-1,iz),idTT(ix,iy,iz-1),
     &              TT(ix0,iy,iz),  TT(ix,iy-1,iz),  TT(ix,iy,iz-1),
     &        TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)
      endif

      if(iy.ne.ny .and. iz.ne.0)then
         rT=renew(idTT(ix0,iy,iz),idTT(ix,iy+1,iz),idTT(ix,iy,iz-1),
     &              TT(ix0,iy,iz),  TT(ix,iy+1,iz),  TT(ix,iy,iz-1),
     &        TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)
      endif

      if(iy.ne.0 .and. iz.ne.nz)then
         rT=renew(idTT(ix0,iy,iz),idTT(ix,iy-1,iz),idTT(ix,iy,iz+1),
     &              TT(ix0,iy,iz),  TT(ix,iy-1,iz),  TT(ix,iy,iz+1),
     &        TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)
      endif

      if(iy.ne.ny .and. iz.ne.nz)then
         rT=renew(idTT(ix0,iy,iz),idTT(ix,iy+1,iz),idTT(ix,iy,iz+1),
     &              TT(ix0,iy,iz),  TT(ix,iy+1,iz),  TT(ix,iy,iz+1),
     &        TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)
      endif

      return
 30   continue

!--- Update from "South" or "North"

      if (idr.eq.3) then
         iy0=iy-1
      else
         iy0=iy+1
      endif

      if(idSlow.eq.1)then
         v1=vel(ix,iy0,iz)
         slow2=(averslow(v0,v1))**2
      endif

      if(ix.ne.0 .and. iz.ne.0)then
         rT=renew(idTT(ix-1,iy,iz),idTT(ix,iy0,iz),idTT(ix,iy,iz-1),
     &              TT(ix-1,iy,iz),  TT(ix,iy0,iz),  TT(ix,iy,iz-1),
     &        TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)
      endif

      if(ix.ne.nx .and. iz.ne.0)then
         rT=renew(idTT(ix+1,iy,iz),idTT(ix,iy0,iz),idTT(ix,iy,iz-1),
     &              TT(ix+1,iy,iz),  TT(ix,iy0,iz),  TT(ix,iy,iz-1),
     &        TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)
      endif

      if(ix.ne.0 .and. iz.ne.nz)then
         rT=renew(idTT(ix-1,iy,iz),idTT(ix,iy0,iz),idTT(ix,iy,iz+1),
     &              TT(ix-1,iy,iz),  TT(ix,iy0,iz),  TT(ix,iy,iz+1),
     &        TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)
      endif

      if(ix.ne.nx .and. iz.ne.nz)then
         rT=renew(idTT(ix+1,iy,iz),idTT(ix,iy0,iz),idTT(ix,iy,iz+1),
     &              TT(ix+1,iy,iz),  TT(ix,iy0,iz),  TT(ix,iy,iz+1),
     &        TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)
      endif

      return
 50   continue

!--- Update from "Bottom" or "Top"

      if (idr.eq.5) then
         iz0=iz-1
      else
         iz0=iz+1
      endif

      if(idSlow.eq.1)then
         v1=vel(ix,iy,iz0)
         slow2=(averslow(v0,v1))**2
      endif

      if(ix.ne.0 .and. iy.ne.0)then
         rT=renew(idTT(ix-1,iy,iz),idTT(ix,iy-1,iz),idTT(ix,iy,iz0),
     &              TT(ix-1,iy,iz),  TT(ix,iy-1,iz),  TT(ix,iy,iz0),
     &        TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)
      endif

      if(ix.ne.nx .and. iy.ne.0)then
         rT=renew(idTT(ix+1,iy,iz),idTT(ix,iy-1,iz),idTT(ix,iy,iz0),
     &              TT(ix+1,iy,iz),  TT(ix,iy-1,iz),  TT(ix,iy,iz0),
     &        TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)
      endif

      if(ix.ne.0 .and. iy.ne.ny)then
         rT=renew(idTT(ix-1,iy,iz),idTT(ix,iy+1,iz),idTT(ix,iy,iz0),
     &              TT(ix-1,iy,iz),  TT(ix,iy+1,iz),  TT(ix,iy,iz0),
     &        TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)
      endif

      if(ix.ne.nx .and. iy.ne.ny)then
         rT=renew(idTT(ix+1,iy,iz),idTT(ix,iy+1,iz),idTT(ix,iy,iz0),
     &              TT(ix+1,iy,iz),  TT(ix,iy+1,iz),  TT(ix,iy,iz0),
     &        TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)
      endif

      return

!========================
!=== 2D case
!========================

 210  continue
!--- Update from "West" or "East"

      if (idr.eq.1) then
         ix0=ix-1
      else
         ix0=ix+1
      endif

      if(idSlow.eq.1)then
         v1=vel(ix0,iy,iz)
         slow2=(averslow(v0,v1))**2
      endif

      if(iy.ne.0)then
         rT=renew(idTT(ix0,iy,iz),idTT(ix,iy-1,iz), 0,
     &              TT(ix0,iy,iz),  TT(ix,iy-1,iz), zero,
     &        TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)
      endif

      if(iy.ne.ny)then
         rT=renew(idTT(ix0,iy,iz),idTT(ix,iy+1,iz), 0,
     &              TT(ix0,iy,iz),  TT(ix,iy+1,iz), zero,
     &        TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)
      endif

      return
 230  continue

!--- Update from "South" or "North"

      if (idr.eq.3) then
         iy0=iy-1
      else
         iy0=iy+1
      endif

      if(idSlow.eq.1)then
         v1=vel(ix,iy0,iz)
         slow2=(averslow(v0,v1))**2
      endif

      if(ix.ne.0)then
         rT=renew(idTT(ix-1,iy,iz),idTT(ix,iy0,iz), 0,
     &              TT(ix-1,iy,iz),  TT(ix,iy0,iz), zero,
     &        TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)
      endif

      if(ix.ne.nx)then
         rT=renew(idTT(ix+1,iy,iz),idTT(ix,iy0,iz), 0,
     &              TT(ix+1,iy,iz),  TT(ix,iy0,iz), zero,
     &        TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)
      endif

!------------------

      return
      end

