!=======================================================================
      subroutine sethian(idr,nx,ny,nz,ix,iy,iz, dx,dy,dz,idTT,TT,vel)
!=======================================================================
!--- This routine updates "TT(ix,iy,iz)".

      implicit none
      integer idr,nx,ny,nz,ix,iy,iz
      real*8  dx,dy,dz
      integer idTT(0:nx,0:ny,0:nz)
      real*8  TT(0:nx,0:ny,0:nz),vel(0:nx,0:ny,0:nz)

      integer idSlow
      common  /c4Slow/ idSlow

      integer ix0,iy0,iz0
      real*8  v0,v1,rT
      real*8  averslow,renew,slow2,zero

      v0=vel(ix,iy,iz)
      if(idSlow.eq.0) slow2=(1.d0/v0)**2

      if(nz.eq.0) goto 2000

!--- Update from "(ix-1,iy-1,iz-1)":

      if(ix.ne.0 .and. iy.ne.0 .and. iz.ne.0)then

         ix0=ix-1
         iy0=iy-1
         iz0=iz-1

         if(idSlow.eq.1)then
            v1=vel(ix0,iy0,iz0)
            slow2=(averslow(v0,v1))**2
         endif

         rT=renew(idTT(ix0,iy,iz),idTT(ix,iy0,iz),idTT(ix,iy,iz0),
     &              TT(ix0,iy,iz),  TT(ix,iy0,iz),  TT(ix,iy,iz0),
     &              TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)

      endif


!--- Update from "(ix+1,iy-1,iz-1)":

      if(ix.ne.nx .and. iy.ne.0 .and. iz.ne.0)then

         ix0=ix+1
         iy0=iy-1
         iz0=iz-1

         if(idSlow.eq.1)then
            v1=vel(ix0,iy0,iz0)
            slow2=(averslow(v0,v1))**2
         endif

         rT=renew(idTT(ix0,iy,iz),idTT(ix,iy0,iz),idTT(ix,iy,iz0),
     &              TT(ix0,iy,iz),  TT(ix,iy0,iz),  TT(ix,iy,iz0),
     &              TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)

      endif


!--- Update from "(ix-1,iy+1,iz-1)":

      if(ix.ne.0 .and. iy.ne.ny .and. iz.ne.0)then

         ix0=ix-1
         iy0=iy+1
         iz0=iz-1

         if(idSlow.eq.1)then
            v1=vel(ix0,iy0,iz0)
            slow2=(averslow(v0,v1))**2
         endif

         rT=renew(idTT(ix0,iy,iz),idTT(ix,iy0,iz),idTT(ix,iy,iz0),
     &              TT(ix0,iy,iz),  TT(ix,iy0,iz),  TT(ix,iy,iz0),
     &              TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)

      endif


!--- Update from "(ix+1,iy+1,iz-1)":

      if(ix.ne.nx .and. iy.ne.ny .and. iz.ne.0)then

         ix0=ix+1
         iy0=iy+1
         iz0=iz-1

         if(idSlow.eq.1)then
            v1=vel(ix0,iy0,iz0)
            slow2=(averslow(v0,v1))**2
         endif

         rT=renew(idTT(ix0,iy,iz),idTT(ix,iy0,iz),idTT(ix,iy,iz0),
     &              TT(ix0,iy,iz),  TT(ix,iy0,iz),  TT(ix,iy,iz0),
     &              TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)

      endif


!--- Update from "(ix-1,iy-1,iz+1)":

      if(ix.ne.0 .and. iy.ne.0 .and. iz.ne.nz)then

         ix0=ix-1
         iy0=iy-1
         iz0=iz+1

         if(idSlow.eq.1)then
            v1=vel(ix0,iy0,iz0)
            slow2=(averslow(v0,v1))**2
         endif

         rT=renew(idTT(ix0,iy,iz),idTT(ix,iy0,iz),idTT(ix,iy,iz0),
     &              TT(ix0,iy,iz),  TT(ix,iy0,iz),  TT(ix,iy,iz0),
     &              TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)

      endif


!--- Update from "(ix+1,iy-1,iz+1)":

      if(ix.ne.nx .and. iy.ne.0 .and. iz.ne.nz)then

         ix0=ix+1
         iy0=iy-1
         iz0=iz+1

         if(idSlow.eq.1)then
            v1=vel(ix0,iy0,iz0)
            slow2=(averslow(v0,v1))**2
         endif

         rT=renew(idTT(ix0,iy,iz),idTT(ix,iy0,iz),idTT(ix,iy,iz0),
     &              TT(ix0,iy,iz),  TT(ix,iy0,iz),  TT(ix,iy,iz0),
     &              TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)

      endif


!--- Update from "(ix-1,iy+1,iz+1)":

      if(ix.ne.0 .and. iy.ne.ny .and. iz.ne.nz)then

         ix0=ix-1
         iy0=iy+1
         iz0=iz+1

         if(idSlow.eq.1)then
            v1=vel(ix0,iy0,iz0)
            slow2=(averslow(v0,v1))**2
         endif

         rT=renew(idTT(ix0,iy,iz),idTT(ix,iy0,iz),idTT(ix,iy,iz0),
     &              TT(ix0,iy,iz),  TT(ix,iy0,iz),  TT(ix,iy,iz0),
     &              TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)

      endif


!--- Update from "(ix+1,iy+1,iz+1)":

      if(ix.ne.nx .and. iy.ne.ny .and. iz.ne.nz)then

         ix0=ix+1
         iy0=iy+1
         iz0=iz+1

         if(idSlow.eq.1)then
            v1=vel(ix0,iy0,iz0)
            slow2=(averslow(v0,v1))**2
         endif

         rT=renew(idTT(ix0,iy,iz),idTT(ix,iy0,iz),idTT(ix,iy,iz0),
     &              TT(ix0,iy,iz),  TT(ix,iy0,iz),  TT(ix,iy,iz0),
     &              TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)

      endif


      return


!========================
!=== 2D case
!========================

 2000 zero=0.d0
      iz=0
      dz=zero


!--- Update from "(ix-1,iy-1)"

      if(ix.ne.0 .and. iy.ne.0)then

         ix0=ix-1
         iy0=iy-1

         if(idSlow.eq.1)then
            v1=vel(ix0,iy0,iz)
            slow2=(averslow(v0,v1))**2
         endif

         rT=renew(idTT(ix0,iy,iz),idTT(ix,iy0,iz), 0,
     &              TT(ix0,iy,iz),  TT(ix,iy0,iz), zero,
     &              TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)

      endif


!--- Update from "(ix+1,iy-1)"

      if(ix.ne.nx .and. iy.ne.0)then

         ix0=ix+1
         iy0=iy-1

         if(idSlow.eq.1)then
            v1=vel(ix0,iy0,iz)
            slow2=(averslow(v0,v1))**2
         endif

         rT=renew(idTT(ix0,iy,iz),idTT(ix,iy0,iz), 0,
     &              TT(ix0,iy,iz),  TT(ix,iy0,iz), zero,
     &              TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)

      endif


!--- Update from "(ix-1,iy+1)"

      if(ix.ne.0 .and. iy.ne.ny)then

         ix0=ix-1
         iy0=iy+1

         if(idSlow.eq.1)then
            v1=vel(ix0,iy0,iz)
            slow2=(averslow(v0,v1))**2
         endif

         rT=renew(idTT(ix0,iy,iz),idTT(ix,iy0,iz), 0,
     &              TT(ix0,iy,iz),  TT(ix,iy0,iz), zero,
     &              TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)

      endif


!--- Update from "(ix+1,iy+1)"

      if(ix.ne.nx .and. iy.ne.ny)then

         ix0=ix+1
         iy0=iy+1

         if(idSlow.eq.1)then
            v1=vel(ix0,iy0,iz)
            slow2=(averslow(v0,v1))**2
         endif

         rT=renew(idTT(ix0,iy,iz),idTT(ix,iy0,iz), 0,
     &              TT(ix0,iy,iz),  TT(ix,iy0,iz), zero,
     &              TT(ix,iy,iz),slow2,dx,dy,dz)
         TT(ix,iy,iz)=min(TT(ix,iy,iz),rT)

      endif


!------------------

      return
      end

