!=======================================================================
      subroutine reversemarch(nx,ny,nz,nGA,level,ierr, 
     &      dx,dy,dz, TM,idTT,GA,TT,vel)
!=======================================================================
      implicit none
      integer nx,ny,nz,nGA,level,ierr
      real*8  dx,dy,dz,TM
      integer idTT(0:nx,0:ny,0:nz),GA(3,*)
      real*8  TT(0:nx,0:ny,0:nz),vel(0:nx,0:ny,0:nz)

      integer i,ix,iy,iz
      real*8  TT0

      do i=nGA,1,-1

         ix=GA(1,i)
         iy=GA(2,i)
         iz=GA(3,i)

         TT0=TT(ix,iy,iz)

         if(TT0.le.TM)then

         !--- Update "West"

            if(ix.ne.0)then
            if(idTT(ix-1,iy,iz).le.1 .and. TT(ix-1,iy,iz).gt.TT0)then
               call update1(2,nx,ny,nz,ix-1,iy,iz, dx,dy,dz,idTT,TT,vel)
            endif
            endif

         !--- Update "East"

            if(ix.ne.nx)then
            if(idTT(ix+1,iy,iz).le.1 .and. TT(ix+1,iy,iz).gt.TT0)then
               call update1(1,nx,ny,nz,ix+1,iy,iz, dx,dy,dz,idTT,TT,vel)
            endif
            endif

         !--- Update "South"

            if(iy.ne.0)then
            if(idTT(ix,iy-1,iz).le.1 .and. TT(ix,iy-1,iz).gt.TT0)then
               call update1(4,nx,ny,nz,ix,iy-1,iz, dx,dy,dz,idTT,TT,vel)
            endif
            endif

         !--- Update "North"

            if(iy.ne.ny)then
            if(idTT(ix,iy+1,iz).le.1 .and. TT(ix,iy+1,iz).gt.TT0)then
               call update1(3,nx,ny,nz,ix,iy+1,iz, dx,dy,dz,idTT,TT,vel)
            endif
            endif

            if(nz.eq.0)then
            else
         !--- Update "Bottom"

            if(iz.ne.0)then
            if(idTT(ix,iy,iz-1).le.1 .and. TT(ix,iy,iz-1).gt.TT0)then
               call update1(6,nx,ny,nz,ix,iy,iz-1, dx,dy,dz,idTT,TT,vel)
            endif
            endif

         !--- Update "Top"

            if(iz.ne.nz)then
            if(idTT(ix,iy,iz+1).le.1 .and. TT(ix,iy,iz+1).gt.TT0)then
               call update1(5,nx,ny,nz,ix,iy,iz+1, dx,dy,dz,idTT,TT,vel)
            endif
            endif

            endif

         endif
      enddo

      return
      end

!=======================================================================
      subroutine reversemarch2(nx,ny,nz,nGA,level,ierr, 
     &      dx,dy,dz, TM,idTT,GA,TT,vel)
!=======================================================================
      implicit none
      integer nx,ny,nz,nGA,level,ierr
      real*8  dx,dy,dz,TM
      integer idTT(0:nx,0:ny,0:nz),GA(3,*)
      real*8  TT(0:nx,0:ny,0:nz),vel(0:nx,0:ny,0:nz)

      integer i,ix,iy,iz
      real*8  TT0

      do i=nGA,1,-1

         ix=GA(1,i)
         iy=GA(2,i)
         iz=GA(3,i)

         TT0=TT(ix,iy,iz)

         if(TT0.le.TM)then

         !--- Update "West"

            if(ix.ne.0)then
            if(idTT(ix-1,iy,iz).le.1 .and. TT(ix-1,iy,iz).gt.TT0)then
              call skimSeth(2,nx,ny,nz,ix-1,iy,iz, dx,dy,dz,idTT,TT,vel)
            endif
            endif

         !--- Update "East"

            if(ix.ne.nx)then
            if(idTT(ix+1,iy,iz).le.1 .and. TT(ix+1,iy,iz).gt.TT0)then
              call skimSeth(1,nx,ny,nz,ix+1,iy,iz, dx,dy,dz,idTT,TT,vel)
            endif
            endif

         !--- Update "South"

            if(iy.ne.0)then
            if(idTT(ix,iy-1,iz).le.1 .and. TT(ix,iy-1,iz).gt.TT0)then
              call skimSeth(4,nx,ny,nz,ix,iy-1,iz, dx,dy,dz,idTT,TT,vel)
            endif
            endif

         !--- Update "North"

            if(iy.ne.ny)then
            if(idTT(ix,iy+1,iz).le.1 .and. TT(ix,iy+1,iz).gt.TT0)then
              call skimSeth(3,nx,ny,nz,ix,iy+1,iz, dx,dy,dz,idTT,TT,vel)
            endif
            endif

            if(nz.eq.0)then
            else
         !--- Update "Bottom"

            if(iz.ne.0)then
            if(idTT(ix,iy,iz-1).le.1 .and. TT(ix,iy,iz-1).gt.TT0)then
              call skimSeth(6,nx,ny,nz,ix,iy,iz-1, dx,dy,dz,idTT,TT,vel)
            endif
            endif

         !--- Update "Top"

            if(iz.ne.nz)then
            if(idTT(ix,iy,iz+1).le.1 .and. TT(ix,iy,iz+1).gt.TT0)then
              call skimSeth(5,nx,ny,nz,ix,iy,iz+1, dx,dy,dz,idTT,TT,vel)
            endif
            endif

            endif

         endif
      enddo

      return
      end

