!=======================================================================
      real*8 function renew(i1,i2,i3,t1,t2,t3,t0,slow2,dx,dy,dz)
!=======================================================================
      implicit none
      integer i1,i2,i3
      real*8  t1,t2,t3,t0,slow2,dx,dy,dz

      real*8  a,b,c,fac,tmp,slow1

      a=0.d0
      b=0.d0
      c=-slow2   !! =-slow**2

!---- RENEW "TT(i,j,k)" from t0,t1,t2

      if(i1.gt.0 .and. t1.lt.t0) then
         fac=1.d0/(dx)**2
         a=a+fac
         b=b+t1*fac
         c=c+(t1)**2*fac
      endif

      if(i2.gt.0 .and. t2.lt.t0) then
         fac=1.d0/(dy)**2
         a=a+fac
         b=b+t2*fac
         c=c+(t2)**2*fac
      endif

      if(i3.gt.0 .and. t3.lt.t0) then
         fac=1.d0/(dz)**2
         a=a+fac
         b=b+t3*fac
         c=c+(t3)**2*fac
      endif

      if(a.eq.0.d0)then
         slow1=dsqrt(slow2)
         if(dz.gt.(1.d-7))then
            renew=min(t1+dx*slow1,t2+dy*slow1,t3+dz*slow1)
         else
            renew=min(t1+dx*slow1,t2+dy*slow1)
         endif
      else
         tmp=b**2-a*c
         if(tmp.ge.0.d0) then
            renew=(b+dsqrt(tmp))/a
         else
            renew=1.0d5
         endif
      endif

      return
      end

