C=======================================================================
       real*8 FUNCTION linvel8 (X1,Y1,Z1,X2,Y2,Z2,V0,KX,KY,KZ)
C=======================================================================
C  Compute the travel time between two points in a medium
C  with a linearly varying velocity, V0+x*KX+y*KY+z*KZ.
C  Note: the corresponding point for V0 is (0.,0.,0.)

       IMPLICIT LOGICAL (A-Z)
       real*8 X1,Y1,Z1,X2,Y2,Z2,V0,KX,KY,KZ
       real*8 R1,R2,R3,V1,V2
       R1 = (X2-X1)**2+(Y2-Y1)**2+(Z2-Z1)**2
       R3 = KX**2+KY**2+KZ**2
       V1 = V0+KX*X1+KY*Y1+KZ*Z1
       V2 = V0+KX*X2+KY*Y2+KZ*Z2
       R2 = (R1*R3)/(R1*R3+4.*V1*V2)

C---   Compute travel time using Evjen's eqn(40) on page 41.

       IF (R2.GE..01) THEN
          R2=DSQRT(R2)
          LINVEL8=DLOG((1.d0+R2)/(1.d0-R2))/DSQRT(R3)
       ELSE
          IF (R3.GT.0.d0) THEN
             R1=DSQRT(R2/R3)
             LINVEL8=R1*(2.d0+R2*(0.6666667
     &                  +R2*(0.3999777+R2*0.2898078)))
          ELSE
             LINVEL8=DSQRT(R1)/V0
          ENDIF
       ENDIF

       RETURN
       END

