!=======================================================================
      subroutine initFMM(nx,ny,nz,nGA,maxGA,level,ierr,
     &    xmin,xmax,ymin,ymax,zmin,zmax, dx,dy,dz,
     &    xs,ys,zs,boxinit, idTT,GA,TT,vel)
!=======================================================================
      implicit none
      integer nx,ny,nz,nGA,maxGA,level,ierr
      real*8  xmin,xmax,ymin,ymax,zmin,zmax, dx,dy,dz
      real*8  xs,ys,zs,boxinit
      integer idTT(0:nx,0:ny,0:nz),GA(3,*)
      real*8  TT(0:nx,0:ny,0:nz),vel(0:nx,0:ny,0:nz)

      integer ix,iy,iz,i,j,level0,ntmp
      integer init_front,idlin,isx,isy,isz
      integer n11,n12,n21,n22,n31,n32
      real*8  linvel8,xsd,ysd,zsd,px,py,pz
      real*8  vx,vy,vz,al0,alx,aly,alz

      if(level.ge.1) print'("INIT_FMM:")'
      if(level.ge.2) print*,"nx=",nx," ny=",ny," nz=",nz
      if(level.ge.2) print*,"boxinit=",boxinit


!--- General setting

      level0=0

      do iz=0,nz
      do iy=0,ny
      do ix=0,nx
         TT(ix,iy,iz)=1.0d5
      enddo
      enddo
      enddo

      do iz=0,nz
      do iy=0,ny
      do ix=0,nx
         idTT(ix,iy,iz)=0
      enddo
      enddo
      enddo

      do i=1,maxGA
         GA(1,i)=-1
         GA(2,i)=-1
         GA(3,i)=-1
      enddo

!=== Initialization "TT" near the source

      idlin=1
      if(boxinit.le.10.) then
         init_front=max(1,nint(boxinit))
      else
         init_front=max(1,nint(boxinit/dx))
      endif

      isx=min(nx,max(0,nint((xs-xmin)/dx)))
      isy=min(ny,max(0,nint((ys-ymin)/dy)))
      if(nz.eq.0)then
         isz=0
      else
         isz=min(nz,max(0,nint((zs-zmin)/dz)))
      endif

      n11=max(0, isx-init_front)
      n12=min(nx,isx+init_front)
      n21=max(0, isy-init_front)
      n22=min(ny,isy+init_front)
      n31=max(0, isz-init_front)
      n32=min(nz,isz+init_front)

!--- "TT" for Linear models

      if(idlin.eq.1) then

         al0=vel(n11,n21,n31)
         alx=vel(n12,n21,n31)
         aly=vel(n11,n22,n31)
         alz=vel(n11,n21,n32)

         vx=(alx-al0)/(dble(n12-n11)*dx)
         vy=(aly-al0)/(dble(n22-n21)*dy)
         if(nz.eq.0)then
            vz=0.d0
            dz=0.d0
            zs=0.d0
         else
            vz=(alz-al0)/(dble(n32-n31)*dz)
         endif

         xsd=xs-dble(n11)*dx  ! X(n11,n21,n31) is viewed as the origin
         ysd=ys-dble(n21)*dy
         zsd=zs-dble(n31)*dz

         do iz=n31,n32
            pz=dble(iz-n31)*dz
         do iy=n21,n22
            py=dble(iy-n21)*dy
         do ix=n11,n12
            px=dble(ix-n11)*dx
            TT(ix,iy,iz)=linvel8(xsd,ysd,zsd,px,py,pz,al0,vx,vy,vz)
         end do
         end do
         end do

         if(level.ge.4) print*,"TT=",(TT(ix,isy,isz),ix=n11,n12)

!--- "TT" for General models
      else

         stop 'ERROR: initFMM.f: No initialization for general media'

      endif


!=== Initialize "idTT"

      do iz=min(nz,n31+1),(n32-1)
      do iy=n21+1,n22-1
      do ix=n11+1,n12-1
         idTT(ix,iy,iz)=2
      enddo
      enddo
      enddo

      do iz=n31,n32
      do iy=n21,n22
         if(n11.ne.0)then
            idTT(n11,iy,iz)=1
            nGA=nGA+1
            GA(1,nGA)=n11
            GA(2,nGA)=iy
            GA(3,nGA)=iz
         endif
         if(n12.ne.nx)then
            idTT(n12,iy,iz)=1
            nGA=nGA+1
            GA(1,nGA)=n12
            GA(2,nGA)=iy
            GA(3,nGA)=iz
         endif
      enddo
      enddo

      do iz=n31,n32
      do ix=n11+1,n12-1
         if(n21.ne.0)then
            idTT(ix,n21,iz)=1
            nGA=nGA+1
            GA(1,nGA)=ix
            GA(2,nGA)=n21
            GA(3,nGA)=iz
         endif
         if(n22.ne.ny)then
            idTT(ix,n22,iz)=1
            nGA=nGA+1
            GA(1,nGA)=ix
            GA(2,nGA)=n22
            GA(3,nGA)=iz
         endif
      enddo
      enddo

      do iy=n21+1,n22-1
      do ix=n11+1,n12-1
         if(n31.ne.0)then
            idTT(ix,iy,n31)=1
            nGA=nGA+1
            GA(1,nGA)=ix
            GA(2,nGA)=iy
            GA(3,nGA)=n31
         endif
         if(n32.ne.nz)then
            idTT(ix,iy,n32)=1
            nGA=nGA+1
            GA(1,nGA)=ix
            GA(2,nGA)=iy
            GA(3,nGA)=n32
         endif
      enddo
      enddo

!--- Check if "maxGA" is set large enough

      if(maxGA.lt.nGA) stop 'Error: initFMM.f: maxGA is not enough.'


!--- Now, sort the values on "GA" using "HeapUp"

      ntmp=1
      j=0
      do while(ntmp.le.nGA)
         ntmp=ntmp*2
         j=j+1
      enddo
      ntmp=j

      do j=1,ntmp
      do i=nGA,2,-1
         call heapUp(0,nx,ny,nz,i,maxGA,level0,ierr, GA,TT)
      enddo
      enddo

      if(level.ge.4)then
         do i=1,nGA
         print*,i,GA(1,i),GA(2,i),GA(3,i),TT(GA(1,i),GA(2,i),GA(3,i))
         enddo
      endif


      return
      end

