!=======================================================================
      subroutine heapDown(nx,ny,nz,MT1,lastGA,maxGA,level,ierr, GA,TT)
!=======================================================================
! This module eliminates the smallest TT on the top of the binary tree
! and sorts TTs by searching down the tree.

! MT1:    indicates the first empty in the array GA
! lastGA: indicates the last nontrivial entry in the array GA

      implicit none
      integer nx,ny,nz,MT1,lastGA,maxGA,level,ierr
      integer GA(3,*)
      real*8  TT(0:nx,0:ny,0:nz)

      integer i,k,k0,k1,k2,ifill,idown,maxGA_half,id_end

      if(level.ge.1) print'("HeapDown:")'
      if(level.ge.2) print*,"nx=",nx," ny=",ny," nz=",nz


!--- HeapDown:

      k=1
      ifill=3

      maxGA_half=maxGA/2
      id_end=0

      do while (ifill.ge.1 .and. id_end.eq.0)

         k1=2*k
         k2=k1+1
         if(k1.ge.maxGA_half) id_end=1

         ifill=0
         if(GA(1,k1).ge.0) ifill=ifill+1
         if(GA(1,k2).ge.0) ifill=ifill+2

         idown=ifill

         if(ifill.eq.3)then

            if( TT(GA(1,k1),GA(2,k1),GA(3,k1)) .lt.
     &          TT(GA(1,k2),GA(2,k2),GA(3,k2)) ) then
               idown=1
            else
               idown=2
            endif

         endif


         if(idown.eq.0)then

            GA(1,k)=-1
            GA(2,k)=-1
            GA(3,k)=-1
            MT1=min(MT1,k)

         else if(idown.eq.1)then

            GA(1,k)=GA(1,k1)
            GA(2,k)=GA(2,k1)
            GA(3,k)=GA(3,k1)
            GA(1,k1)=-1
            GA(2,k1)=-1
            GA(3,k1)=-1
            if(id_end.eq.1) MT1=min(MT1,k1)

            k=k1

         else if(idown.eq.2)then

            GA(1,k)=GA(1,k2)
            GA(2,k)=GA(2,k2)
            GA(3,k)=GA(3,k2)
            GA(1,k2)=-1
            GA(2,k2)=-1
            GA(3,k2)=-1
            if(id_end.eq.1) MT1=min(MT1,k2)

            k=k2

         endif

      enddo


!--- adjust "MT1" and "lastGA"

      do while (GA(1,MT1).ge.0)
         MT1=MT1+1
         print*,"heapDown.f: *********** MT1=MT1+1 **************"
      enddo

      do while (GA(1,lastGA).lt.0)
         lastGA=lastGA-1
      enddo


      return
      end

