!=======================================================================
      subroutine gmmplus(nx,ny,nz,level,maxGA,num_GM,idGMM,idsethian,
     &    ierr,idAvSlow, xmin,xmax,ymin,ymax,zmin,zmax,
     &    xs,ys,zs,boxinit, idTT,GA,TT,vel,wksp)
!=======================================================================
!--- It solves 2D (nz.eq.0) and 3D (nz.ne.0) eikonal equations, using
!--- the Group Marching Method (GMM) or Fast Marching Method (FMM)
!
! INPUTS:
!   idGMM=1: the GMM (for 2D or 3D)
!        =0: Sethian's FMM (only for 3D)
!   idsethian=1: Sethian's updating method will be used for GMM.
!            =0: An improved version is used (for GMM_2D only).
!   boxinit: distance from the source to be initialized analytically,
!            assuming that the media is linear near the source.
!=======================================================================

      implicit none
      integer nx,ny,nz,level,maxGA,num_GM,idGMM,idsethian,ierr,idAvSlow
      real*8  xmin,xmax,ymin,ymax,zmin,zmax,xs,ys,zs,boxinit
      integer idTT(0:nx,0:ny,0:nz),GA(3,*)
      real*8  TT(0:nx,0:ny,0:nz),vel(0:nx,0:ny,0:nz),wksp(*)

      integer ix,iy,iz,nGA,MT1,lastGA
      real*8  dx,dy,dz
      real*8  smin,hmin,gamma,TM,delTM
      real*8  angx,angy,angz
      common  /c4angle/ angx,angy,angz
      integer idSlow
      common  /c4Slow/ idSlow

      if(level.ge.1) then
         if(idGMM.eq.1) print'("GMM: ",$)'
         if(idGMM.ne.1) print'("FMM: ",$)'
         print*,"nx=",nx," ny=",ny," nz=",nz
      endif

      if(nz.eq.0) idGMM=1       !! 2D case: GMM only
      if(nz.ne.0) idsethian=1   !! Use Sethian's update for GMM_3D

!--- Initialization: Parameters

      nGA=0
      num_GM=0
      idSlow=idAvSlow

      smin=0.0d0
      do iz=0,nz
      do iy=0,ny
      do ix=0,nx
         smin=max(smin,vel(ix,iy,iz))
      enddo
      enddo
      enddo
      smin=1.d0/smin

      dx=(xmax-xmin)/dble(nx)
      dy=(ymax-ymin)/dble(ny)
      dz=(zmax-zmin)/dble(max(1,nz))

      if(nz.eq.0)then
         dz=0.d0
         hmin=min(dx,dy)
         gamma=1.d0/dsqrt(2.d0)
      else
         hmin=min(dx,dy,dz)
*         gamma=1.d0/dsqrt(3.d0)
         gamma=0.5d0
      endif

      delTM=gamma*hmin*smin
      if(level.ge.1) print*,"dx=",dx," dy=",dy," dz=",dz

      if(idGMM.eq.1 .and. level.ge.2)then
         print*,"smin=",smin," gamma=",gamma
         print*,"delTM=gamma*hmin*smin=",delTM
      endif

!--- the factors for the "maximum angle condition"

      if(nz.eq.0)then
         angx=dx**2/(dx**2+dy**2)
         angy=dy**2/(dx**2+dy**2)
         angz=0.d0
      else
         angx=dx**2/min(dx**2+dy**2,dx**2+dz**2)
         angy=dy**2/min(dy**2+dx**2,dy**2+dz**2)
         angz=dz**2/min(dz**2+dx**2,dz**2+dy**2)
      endif


!=============================================
!--- Initialization && Marching with FMM/GMM
!=============================================

!-------------------------------------------------------------
      if(idGMM.eq.1) then
!-------------------------------------------------------------

         call initGMM(nx,ny,nz,nGA,maxGA,level,ierr,
     &       xmin,xmax,ymin,ymax,zmin,zmax, dx,dy,dz,
     &       xs,ys,zs,boxinit, TM,idTT,GA,TT,vel)

         if(ierr.ne.0)return

         call ttGMM(nx,ny,nz,nGA,maxGA,num_GM,idsethian,level,ierr,
     &             dx,dy,dz,TM,delTM, idTT,GA,TT,vel,wksp)

!-------------------------------------------------------------
      else
!-------------------------------------------------------------

         call initFMM(nx,ny,nz,nGA,maxGA,level,ierr,
     &       xmin,xmax,ymin,ymax,zmin,zmax, dx,dy,dz,
     &       xs,ys,zs,boxinit, idTT,GA,TT,vel)

         if(ierr.ne.0)return

         MT1=nGA+1
         lastGA=nGA

         call ttFMM(nx,ny,nz,MT1,lastGA,maxGA,level,ierr,
     &              dx,dy,dz, idTT,GA,TT,vel,wksp)

!-------------------------------------------------------------
      endif
!-------------------------------------------------------------

      return
      end

