!=======================================================================
      subroutine fwdmarch(nx,ny,nz,nGA,maxGA,level,ierr, 
     &      dx,dy,dz, TM,delTM,idTT,GA,TT,vel)
!=======================================================================
      implicit none
      integer nx,ny,nz,nGA,maxGA,level,ierr
      real*8  dx,dy,dz,TM,delTM
      integer idTT(0:nx,0:ny,0:nz),GA(3,*)
      real*8  TT(0:nx,0:ny,0:nz),vel(0:nx,0:ny,0:nz)

      integer i,ix,iy,iz,nGA0
      real*8  TT0

      nGA0=nGA

      do i=1,nGA

         if(i.gt.nGA0) goto 9999

         ix=GA(1,i)
         iy=GA(2,i)
         iz=GA(3,i)

         TT0=TT(ix,iy,iz)

         if(TT0.le.TM)then

         !--- Update "West"

            if(ix.ne.0)then
            if(idTT(ix-1,iy,iz).le.1 .and. TT(ix-1,iy,iz).gt.TT0)then
               call update1(2,nx,ny,nz,ix-1,iy,iz, dx,dy,dz,idTT,TT,vel)
               if(idTT(ix-1,iy,iz).eq.0)then
                  nGA0=nGA0+1
                  GA(1,nGA0)=ix-1
                  GA(2,nGA0)=iy
                  GA(3,nGA0)=iz
                  idTT(ix-1,iy,iz)=1
               endif
            endif
            endif

         !--- Update "East"

            if(ix.ne.nx)then
            if(idTT(ix+1,iy,iz).le.1 .and. TT(ix+1,iy,iz).gt.TT0)then
               call update1(1,nx,ny,nz,ix+1,iy,iz, dx,dy,dz,idTT,TT,vel)
               if(idTT(ix+1,iy,iz).eq.0)then
                  nGA0=nGA0+1
                  GA(1,nGA0)=ix+1
                  GA(2,nGA0)=iy
                  GA(3,nGA0)=iz
                  idTT(ix+1,iy,iz)=1
               endif
            endif
            endif

         !--- Update "South"

            if(iy.ne.0)then
            if(idTT(ix,iy-1,iz).le.1 .and. TT(ix,iy-1,iz).gt.TT0)then
               call update1(4,nx,ny,nz,ix,iy-1,iz, dx,dy,dz,idTT,TT,vel)
               if(idTT(ix,iy-1,iz).eq.0)then
                  nGA0=nGA0+1
                  GA(1,nGA0)=ix
                  GA(2,nGA0)=iy-1
                  GA(3,nGA0)=iz
                  idTT(ix,iy-1,iz)=1
               endif
            endif
            endif

         !--- Update "North"

            if(iy.ne.ny)then
            if(idTT(ix,iy+1,iz).le.1 .and. TT(ix,iy+1,iz).gt.TT0)then
               call update1(3,nx,ny,nz,ix,iy+1,iz, dx,dy,dz,idTT,TT,vel)
               if(idTT(ix,iy+1,iz).eq.0)then
                  nGA0=nGA0+1
                  GA(1,nGA0)=ix
                  GA(2,nGA0)=iy+1
                  GA(3,nGA0)=iz
                  idTT(ix,iy+1,iz)=1
               endif
            endif
            endif

            if(nz.eq.0)then
            else
         !--- Update "Bottom"

            if(iz.ne.0)then
            if(idTT(ix,iy,iz-1).le.1 .and. TT(ix,iy,iz-1).gt.TT0)then
               call update1(6,nx,ny,nz,ix,iy,iz-1, dx,dy,dz,idTT,TT,vel)
               if(idTT(ix,iy,iz-1).eq.0)then
                  nGA0=nGA0+1
                  GA(1,nGA0)=ix
                  GA(2,nGA0)=iy
                  GA(3,nGA0)=iz-1
                  idTT(ix,iy,iz-1)=1
               endif
            endif
            endif

         !--- Update "Top"

            if(iz.ne.nz)then
            if(idTT(ix,iy,iz+1).le.1 .and. TT(ix,iy,iz+1).gt.TT0)then
               call update1(5,nx,ny,nz,ix,iy,iz+1, dx,dy,dz,idTT,TT,vel)
               if(idTT(ix,iy,iz+1).eq.0)then
                  nGA0=nGA0+1
                  GA(1,nGA0)=ix
                  GA(2,nGA0)=iy
                  GA(3,nGA0)=iz+1
                  idTT(ix,iy,iz+1)=1
               endif
            endif
            endif

            endif

         !--- Eliminate "GA(.,i)" out of "GA"

            GA(1,i)=GA(1,nGA0)
            GA(2,i)=GA(2,nGA0)
            GA(3,i)=GA(3,nGA0)
            nGA0=nGA0-1
            idTT(ix,iy,iz)=2

         endif

      enddo

 9999 nGA=nGA0
      if(maxGA.lt.nGA)stop'Error: forwardmarch.f: maxGA is not enough.'

      return
      end

!=======================================================================
      subroutine fwdmarch2(nx,ny,nz,nGA,maxGA,level,ierr, 
     &      dx,dy,dz, TM,delTM,idTT,GA,TT,vel)
!=======================================================================
      implicit none
      integer nx,ny,nz,nGA,maxGA,level,ierr
      real*8  dx,dy,dz,TM,delTM
      integer idTT(0:nx,0:ny,0:nz),GA(3,*)
      real*8  TT(0:nx,0:ny,0:nz),vel(0:nx,0:ny,0:nz)

      integer i,ix,iy,iz,nGA0
      real*8  TT0

      nGA0=nGA

      do i=1,nGA

         if(i.gt.nGA0) goto 9999

         ix=GA(1,i)
         iy=GA(2,i)
         iz=GA(3,i)

         TT0=TT(ix,iy,iz)

         if(TT0.le.TM)then

         !--- Update "West"

            if(ix.ne.0)then
            if(idTT(ix-1,iy,iz).le.1 .and. TT(ix-1,iy,iz).gt.TT0)then
              call sethian(2,nx,ny,nz,ix-1,iy,iz, dx,dy,dz,idTT,TT,vel)
               if(idTT(ix-1,iy,iz).eq.0)then
                  nGA0=nGA0+1
                  GA(1,nGA0)=ix-1
                  GA(2,nGA0)=iy
                  GA(3,nGA0)=iz
                  idTT(ix-1,iy,iz)=1
               endif
            endif
            endif

         !--- Update "East"

            if(ix.ne.nx)then
            if(idTT(ix+1,iy,iz).le.1 .and. TT(ix+1,iy,iz).gt.TT0)then
              call sethian(1,nx,ny,nz,ix+1,iy,iz, dx,dy,dz,idTT,TT,vel)
               if(idTT(ix+1,iy,iz).eq.0)then
                  nGA0=nGA0+1
                  GA(1,nGA0)=ix+1
                  GA(2,nGA0)=iy
                  GA(3,nGA0)=iz
                  idTT(ix+1,iy,iz)=1
               endif
            endif
            endif

         !--- Update "South"

            if(iy.ne.0)then
            if(idTT(ix,iy-1,iz).le.1 .and. TT(ix,iy-1,iz).gt.TT0)then
              call sethian(4,nx,ny,nz,ix,iy-1,iz, dx,dy,dz,idTT,TT,vel)
               if(idTT(ix,iy-1,iz).eq.0)then
                  nGA0=nGA0+1
                  GA(1,nGA0)=ix
                  GA(2,nGA0)=iy-1
                  GA(3,nGA0)=iz
                  idTT(ix,iy-1,iz)=1
               endif
            endif
            endif

         !--- Update "North"

            if(iy.ne.ny)then
            if(idTT(ix,iy+1,iz).le.1 .and. TT(ix,iy+1,iz).gt.TT0)then
              call sethian(3,nx,ny,nz,ix,iy+1,iz, dx,dy,dz,idTT,TT,vel)
               if(idTT(ix,iy+1,iz).eq.0)then
                  nGA0=nGA0+1
                  GA(1,nGA0)=ix
                  GA(2,nGA0)=iy+1
                  GA(3,nGA0)=iz
                  idTT(ix,iy+1,iz)=1
               endif
            endif
            endif

            if(nz.eq.0)then
            else
         !--- Update "Bottom"

            if(iz.ne.0)then
            if(idTT(ix,iy,iz-1).le.1 .and. TT(ix,iy,iz-1).gt.TT0)then
              call sethian(6,nx,ny,nz,ix,iy,iz-1, dx,dy,dz,idTT,TT,vel)
               if(idTT(ix,iy,iz-1).eq.0)then
                  nGA0=nGA0+1
                  GA(1,nGA0)=ix
                  GA(2,nGA0)=iy
                  GA(3,nGA0)=iz-1
                  idTT(ix,iy,iz-1)=1
               endif
            endif
            endif

         !--- Update "Top"

            if(iz.ne.nz)then
            if(idTT(ix,iy,iz+1).le.1 .and. TT(ix,iy,iz+1).gt.TT0)then
              call sethian(5,nx,ny,nz,ix,iy,iz+1, dx,dy,dz,idTT,TT,vel)
               if(idTT(ix,iy,iz+1).eq.0)then
                  nGA0=nGA0+1
                  GA(1,nGA0)=ix
                  GA(2,nGA0)=iy
                  GA(3,nGA0)=iz+1
                  idTT(ix,iy,iz+1)=1
               endif
            endif
            endif

            endif

         !--- Eliminate "GA(.,i)" out of "GA"

            GA(1,i)=GA(1,nGA0)
            GA(2,i)=GA(2,nGA0)
            GA(3,i)=GA(3,nGA0)
            nGA0=nGA0-1
            idTT(ix,iy,iz)=2

         endif

      enddo

 9999 nGA=nGA0
      if(maxGA.lt.nGA)stop'Error: forwardmarch.f: maxGA is not enough.'

      return
      end

