!=======================================================================
      subroutine Velocity(nx,ny,nz,idvel,level,ierr,
     &    xmin,xmax,ymin,ymax,zmin,zmax,v0,vx,vy,vz,vel)
!=======================================================================
      implicit none
      integer nx,ny,nz,idvel,level,ierr
      real*8  xmin,xmax,ymin,ymax,zmin,zmax
      real*8  v0,vx,vy,vz
      real*8  vel(0:nx,0:ny,0:nz)

      integer ix,iy,iz,idreal
      integer nx_bgn,nx_end,ny_bgn,ny_end,nz_bgn,nz_end
      real*8  dx,dy,dz
      real*8  vxinc,vyinc,vzinc

      if(level.ge.1) print'("VELOCITY: idvel=",i2)',idvel
      if(level.ge.2) print*,"nx=",nx," ny=",ny," nz=",nz

      idreal=0

      dx=(xmax-xmin)/dble(nx)
      dy=(ymax-ymin)/dble(ny)
      dz=(zmax-zmin)/dble(max(1,nz))

!--- Setting the environment for "vel"

      v0=2000.d0
      vx=0.d0
      vy=0.d0
      vz=0.d0

      if(idvel.eq.0.or.idvel.eq.11)then
      elseif(idvel.eq.1)then
         v0=1000.d0
         vz=0.5d0
         if(nz.eq.0) vy=1.0d0
      elseif(idvel.eq.2)then
         v0=4000.d0
         vx=0.2d0
         vz=-0.5d0
         if(nz.eq.0) vy=0.5d0
      elseif(idvel.eq.3)then
         v0=1000.d0
         vx=0.3d0
         vy=0.2d0
         vz=0.4d0
      elseif(idvel.eq.12)then
         v0=4500.d0
      elseif(idvel.eq.(-1))then
         idreal=1
      else
         print*,"Error: Velocity.f: idvel is set wrong"
         ierr=1
         return
      endif

      if(nz.eq.0) vz=0.d0

!--- Set real "vel"

      if(idreal.eq.1)then
         print*,"Velocity.f: reading a real data"

         print*,"Error: Velocity.f: idreal not yet installed"
         ierr=1

      return
      endif

!--- Set synthetic "vel"

      do iz=0,nz
         vzinc=dble(iz)*dz*vz+v0
      do iy=0,ny
         vyinc=dble(iy)*dy*vy
      do ix=0,nx
         vxinc=dble(ix)*dx*vx
         vel(ix,iy,iz)=vxinc+vyinc+vzinc
      end do
      end do
      end do

      if (idvel.eq.11.or.idvel.eq.12) then
            nx_bgn=nx/4
            nx_end=nx*3/4
            ny_bgn=ny/4
            ny_end=ny*3/4
            nz_bgn=nz/4
            nz_end=nz*2/4
            if(nz.eq.0) ny_end=ny*2/4
         do iz=nz_bgn,nz_end
         do iy=ny_bgn,ny_end
         do ix=nx_bgn,nx_end
            if(idvel.eq.11)then
               vel(ix,iy,iz)=4500.0
            else
               vel(ix,iy,iz)=2000.0
            endif
         end do
         end do
         end do
      endif

!--- Print out

      if(level.ge.2) print*,"v0=",v0," vx=",vx," vy=",vy," vz=",vz

      return
      end

