!=======================================================================
      subroutine numerical(nx,ny,nz, idvel,idGMM,idsethian,num_GM,level,
     &    idAvSlow,xmin,xmax,ymin,ymax,zmin,zmax,boxinit,
     &    xs,ys,zs, v0,vx,vy,vz,TT,wksp,ierr)
!=======================================================================
      implicit none
      integer nx,ny,nz,idvel,level,idGMM,idsethian,num_GM,ierr,idAvSlow
      real*8  xmin,xmax,ymin,ymax,zmin,zmax,boxinit
      real*8  xs,ys,zs,v0,vx,vy,vz
      real*8  TT(0:nx,0:ny,0:nz),wksp(*)

      integer ix,iy,iz
      real*8  dx,dy,dz
      real*8  xsd,ysd,zsd,bot2,top2,bot8,top8,px,py,pz
      real*8  linvel8,trueTT
      logical threeD

      if(level.ge.1) print'("NUMERICAL: idvel=",i1," idsethian=",i1)',
     &    idvel,idsethian
      if(level.ge.2)then
         print*,"nx=",nx," ny=",ny," nz=",nz
         print*,"idGMM=",idGMM," idAvSlow=",idAvSlow
         print*,"domain=(",xmin,xmax,")x(",ymin,ymax,")x(",zmin,zmax,")"
         print*,"xs=",xs," ys=",ys," zs=",zs," boxinit=",boxinit
         print*,"v0=",v0," vx=",vx," vy=",vy," vz=",vz
      endif

      dx=(xmax-xmin)/dble(nx)
      dy=(ymax-ymin)/dble(ny)
      dz=(zmax-zmin)/dble(max(1,nz))

      threeD=.true.
      if(nz.eq.0) threeD=.false.

!-------------------------------------------------
!--- Print out
!-------------------------------------------------

      open(66,file="fort.TTx")
      if(threeD) then
         iy=ny/2
         do ix=0,nx
         do iz=0,nz
            write(66,*) TT(ix,iy,iz)
         enddo
         enddo
      else
         iz=0
         do ix=0,nx
         do iy=0,ny
            write(66,*) TT(ix,iy,iz)
         enddo
         enddo
      endif
      close(66)

      if(threeD) then
         open(66,file="fort.TTy")
         ix=nx/2
         do iy=0,ny
         do iz=0,nz
            write(66,*) TT(ix,iy,iz)
         enddo
         enddo
         close(66)
      endif

      open(68,file="fort.1")
         write(68,'(3(i4),6(f9.5))')
     &       (nx+1),(ny+1),(nz+1),xmin*.001,dx*.001,
     &       ymin*.001,dy*.001,zmin*.001,dz*.001
      close(68)


!-------------------------------------------------
!--- Numerical analysis
!-------------------------------------------------

      xsd=xs-xmin
      ysd=ys-ymin
      zsd=zs-zmin

      bot2=0.d0
      top2=0.d0
      bot8=0.d0
      top8=0.d0


      if(threeD) then

         open(66,file="fort.ERx")
         open(68,file="fort.ERy")

         do iy=0,ny
            py=dble(iy)*dy
         do ix=0,nx
            px=dble(ix)*dx
         do iz=0,nz
            pz=dble(iz)*dz
            trueTT=linvel8(xsd,ysd,zsd,px,py,pz,v0,vx,vy,vz)
            top2=top2+(TT(ix,iy,iz)-trueTT)**2
            bot2=bot2+(trueTT)**2
            top8=max(top8,dabs(TT(ix,iy,iz)-trueTT))
            bot8=max(bot8,trueTT)
            if(iy.eq.(ny/2)) write(66,*) (TT(ix,iy,iz)-trueTT)*1000.d0
            if(ix.eq.(nx/2)) write(68,*) (TT(ix,iy,iz)-trueTT)*1000.d0
         enddo
         enddo
         enddo

         close(66)
         close(68)

         top2=dsqrt(top2/dble(nx*ny*nz))
         bot2=dsqrt(bot2/dble(nx*ny*nz))

      else

         open(66,file="fort.ERx")
         zsd=0.d0
         vz=0.d0
         pz=0.d0

         do ix=0,nx
            px=dble(ix)*dx
         do iy=0,ny
            py=dble(iy)*dy
            trueTT=linvel8(xsd,ysd,zsd,px,py,pz,v0,vx,vy,vz)
            top2=top2+(TT(ix,iy,iz)-trueTT)**2
            bot2=bot2+(trueTT)**2
            top8=max(top8,dabs(TT(ix,iy,iz)-trueTT))
            bot8=max(bot8,trueTT)
            write(66,*) (TT(ix,iy,iz)-trueTT)*1000.d0
         enddo
         enddo
         close(66)

         top2=dsqrt(top2/dble(nx*ny))
         bot2=dsqrt(bot2/dble(nx*ny))

      endif

      print*,"Abs-2Error=",top2,"  Rel-2Error=",top2/bot2
      print*,"Abs-8Error=",top8,"  Rel-8Error=",top8/bot8


      return
      end

