!=======================================================================
      subroutine Driver(nx,ny,nz, idvel,level,maxGA,idGMM,idsethian,
     &    idAvSlow,xmin,xmax,ymin,ymax,zmin,zmax,
     &    xs,ys,zs,boxinit, idTT,GA,TT,vel,wksp,ierr)
!=======================================================================
      implicit none
      integer nx,ny,nz,idvel,level,maxGA,idGMM,idsethian,ierr,idAvSlow
      real*8  xmin,xmax,ymin,ymax,zmin,zmax,xs,ys,zs,boxinit
      integer idTT(0:nx,0:ny,0:nz),GA(3,*)
      real*8  TT(0:nx,0:ny,0:nz),vel(0:nx,0:ny,0:nz),wksp(*)

      integer num_GM
      real*8  v0,vx,vy,vz
      real    utime0,stime0,utime1,stime1

!--- User interface

      if(level.ge.1)then
         print'("DRIVER: idvel=",i2)',idvel
         print*,"nx=",nx," ny=",ny," nz=",nz
      endif
      if(level.ge.2)then
         print*,"domain=(",xmin,xmax,")x(",ymin,ymax,")x(",zmin,zmax,")"
         print*,"xs=",xs," ys=",ys," zs=",zs
      endif

!-------------------------------------------------
!--- Get the velocity
!-------------------------------------------------

      call Velocity(nx,ny,nz,idvel,level,ierr,
     &    xmin,xmax,ymin,ymax,zmin,zmax,v0,vx,vy,vz,vel)


!-------------------------------------------------
!--- Call GMM, the main computation routine
!-------------------------------------------------

      call etimef77(utime0,stime0)

      call gmmplus(nx,ny,nz,level,maxGA,num_GM,idGMM,idsethian,ierr,
     &    idAvSlow,xmin,xmax,ymin,ymax,zmin,zmax,
     &    xs,ys,zs,boxinit, idTT,GA,TT,vel,wksp)

      call etimef77(utime1,stime1)

      if(level.ge.1 .and. (utime1-utime0).gt.1.e-6)then
         print'("ElapsedTime=",f7.2,"u ",f5.2,"s")',
     &     utime1-utime0,stime1-stime0
      endif


      if(level.le.1) return

      call numerical(nx,ny,nz,idvel,idGMM,idsethian,num_GM,level,
     &    idAvSlow,xmin,xmax,ymin,ymax,zmin,zmax,boxinit,
     &    xs,ys,zs, v0,vx,vy,vz,TT,wksp,ierr)

      return
      end

