c ======================================================================
      subroutine solv_ddm(A,x,rhs,truev,betah,id2,iter)
c ======================================================================
      include 'commons.h'
      real A(-mx:mx,lneqn,ndmnx,ndmny),x(lneqn,ndmnx,ndmny,1)
      real rhs(lneqn,ndmnx,ndmny),truev(lneqn,ndmnx,ndmny)
      real betah(1)
      real tarray(2)

      jump=1
 
c----------------------------------------------------------
      do 3000 iter = 1,itmax
c----------------------------------------------------------
 
      id1 = mod(iter+1,2)+1
      id2 = mod(iter  ,2)+1
 
c-- adjust the right hand side & substitute ---------------
 
      call robinbc(iter,x(1,1,1,id1),x(1,1,1,id2),rhs,betah)
      call substit_ddm(mx,lneqn,ndmnx,ndmny,A,x(1,1,1,id2))
*      if (id_fixpoint.eq.1) call fix_point(x(1,1,1,id2),truev)
 
c-- checking the error ------------------------------------
 
      call error8(iter,jump,x(1,1,1,id2),x,truev,terr,ferr,unorm)
      if (idgrid.le.1 .and. level.ge.2) then
           if(iter.eq.1 .or. mod(iter,5).eq.0)
     &     print'(i6,2(f12.6))',iter,terr,ferr
      endif
 
      if (ferr.le.tol .or. iter.ge.itmax) then
        if (level.ge.2 .and. idgrid.eq.1) then
           print'(" DDM_iter =",i4," terr=",1pe9.2," ferr=",1pe9.2)',
     &          iter,terr,ferr
        endif
        goto 9999
      endif
 
c----------------------------------------------------------
 3000 continue
c----------------------------------------------------------
 
 9999 return
      end

c ======================================================================
      subroutine robinbc(iter,xo,xn,rhs,betah)
c ======================================================================
      include 'commons.h'
      common /c4coef02/ de,dw,dn,ds,rx,ry,diag
      real xo(mx,my,ndmnx,ndmny),xn(mx,my,ndmnx,ndmny)
      real rhs(mx,my,ndmnx,ndmny)
      real betah(nx,ny,2)
 
      imode = 1

c-- total filling
 
      do 100 jj = 1,ndmny
      do 100 ii = 1,ndmnx
      do 100 j  = 1,my
      do 100 i  = 1,mx
         xn(i,j,ii,jj)=rhs(i,j,ii,jj)
 100  continue
 
c-- vertical interfaces
 
      i=mx
      ndmnxm1=ndmnx-1

      do 1000 jj = 1,ndmny
         ntmp=(jj-1)*(my-1)
      do 1200 ii = 1,ndmnxm1
         do j = 1,my
            call setcoef(i,j,ii,jj,betah,imode)
            ev_betah=betah(ii,ntmp+j,1)
            tmp2=de-rx
            tmp1=tmp2-ev_betah
            xn(mx,j,ii,jj) = xn(mx,j,ii,jj)  
     &           -tmp1*xo(1,j,ii+1,jj) +tmp2*xo(2,j,ii+1,jj)
            tmp2=dw+rx
            tmp1=tmp2-ev_betah
            xn(1,j,ii+1,jj)= xn(1,j,ii+1,jj)
     &           -tmp1*xo(mx,j,ii,jj)  +tmp2*xo(mx-1,j,ii,jj)
         end do
 1200 continue
 1000 continue
 
c-- horizontal interfaces

      j=my
      ndmnym1=ndmny-1

      do 2000 jj = 1,ndmnym1
      do 2200 ii = 1,ndmnx
         ntmp=(ii-1)*(mx-1)
         do i = 1, mx
            call setcoef(i,j,ii,jj,betah,imode)
            ev_betah=betah(ntmp+i,jj,2)
            tmp2=dn-ry
            tmp1=tmp2-ev_betah
            xn(i,my,ii,jj)  = xn(i,my,ii,jj)  
     &           -tmp1*xo(i,1,ii,jj+1) +tmp2*xo(i,2,ii,jj+1)
            tmp2=ds+ry
            tmp1=tmp2-ev_betah
            xn(i,1,ii,jj+1)= xn(i,1,ii,jj+1)
     &           -tmp1*xo(i,my,ii,jj)  +tmp2*xo(i,my-1,ii,jj)
         end do
 2200 continue
 2000 continue
c
      return
      end

c=======================================================================
      subroutine fix_point(x,truev)
c=======================================================================
      include 'commons.h'
      real x(lneqn,ndmnx,ndmny),truev(lneqn,ndmnx,ndmny)
 
      if (idtrue.eq.1) then
         tmp=x(1,1,1)-truev(1,1,1)
      else
         tmp=x(1,1,1)
      end if

      do jj=1,ndmny
      do ii=1,ndmnx
      do i =1,lneqn
         x(i,ii,jj)=x(i,ii,jj)-tmp
      end do
      end do
      end do

      return
      end

c ======================================================================
      subroutine error8(iter,jump,x,xx,truev,terr,ferr,unorm)
c ======================================================================
      include 'commons.h'
      real x(mx,my,ndmnx,ndmny)
      real xx(mx,my,ndmnx,ndmny,2)
      real truev(mx,my,ndmnx,ndmny)
 
      mxm1 = mx-1
      mym1 = my-1
      mbeg = min(2,mxm1,mym1)
      terr = 0.0
 
      if (iter.eq.1 .and. idtrue.eq.1) then
         unorm= 0.0d0
         do jj= 1,ndmny
         do ii= 1,ndmnx
         do j = 1,my
         do i = 1,mx
            unorm=max(unorm,abs(truev(i,j,ii,jj)))
         end do
         end do
         end do
         end do
      end if
 
c---- iteration errors : |u^n-u^{n-1}| / |u^n|

      ctmp1=0.0d0
      ctmp2=0.0d0
      do 2000 jj= 1,ndmny
      do 2000 ii= 1,ndmnx
      do 2000 j = mbeg,mym1,jump
      do 2000 i = mbeg,mxm1,jump
         ctmp1=max(ctmp1,abs(xx(i,j,ii,jj,1)-xx(i,j,ii,jj,2)))
         ctmp2=max(ctmp2,abs(x(i,j,ii,jj)))
 2000 continue
*      ferr = ctmp1/ctmp2
      ferr = ctmp1/max(ctmp2,eps/tol)
      if (idtrue.ne.1) return

c---- true errors : |u^n-u| / |u|

      enorm= 0.0d0
      do 3000 jj= 1,ndmny
      do 3000 ii= 1,ndmnx
      do 3000 j = mbeg,mym1,jump
      do 3000 i = mbeg,mxm1,jump
         enorm=max(enorm,abs(truev(i,j,ii,jj)-x(i,j,ii,jj)))
 3000 continue
      terr = enorm/unorm
 
      return
      end

