c ======================================================================
      subroutine smoother(id_sgs,nx,ny,it_max,a,x,f)
c ======================================================================
      real a(5,nx,ny),x(nx,ny),f(nx,ny)

c---- id_sgs=0: Gauss-Seidel iteration
c---- id_sgs=1: Symmetric-Gauss-Seidel iteration

      nxm1=nx-1
      nym1=ny-1
      zero=0.0

c------------------------------------------------------
      do it=1,it_max
c------------------------------------------------------

c------  forward Gauss-Seidel

         j=1
         jp1=j+1

         if (id_sgs.eq.1) then
            i=1
            tmp=f(i,j)-( a(4,i,j)*x(i+1,j)+a(5,i,j)*x(i,jp1) )
            x(i,j)=tmp/a(3,i,j)
         end if

         do i=2,nxm1
            tmp=f(i,j)-( a(2,i,j)*x(i-1,j)+a(4,i,j)*x(i+1,j)
     &                  +a(5,i,j)*x(i,jp1) )
            x(i,j)=tmp/a(3,i,j)
         end do

         i=nx
         tmp=f(i,j)-( a(2,i,j)*x(i-1,j)+a(5,i,j)*x(i,jp1) )
         x(i,j)=tmp/a(3,i,j)

         do j=2,nym1
            jm1=j-1
            jp1=j+1

            i=1
            tmp=f(i,j)-( a(1,i,j)*x(i,jm1)
     &                  +a(4,i,j)*x(i+1,j)+a(5,i,j)*x(i,jp1) )
            x(i,j)=tmp/a(3,i,j)

            do i=2,nxm1
               tmp=f(i,j)-( a(1,i,j)*x(i,jm1)+a(2,i,j)*x(i-1,j)
     &                     +a(4,i,j)*x(i+1,j)+a(5,i,j)*x(i,jp1) )
               x(i,j)=tmp/a(3,i,j)
            end do

            i=nx
            tmp=f(i,j)-( a(1,i,j)*x(i,jm1)+a(2,i,j)*x(i-1,j)
     &                  +a(5,i,j)*x(i,jp1) )
            x(i,j)=tmp/a(3,i,j)
         end do

         j=ny
         jm1=j-1

         i=1
         tmp=f(i,j)-( a(1,i,j)*x(i,jm1)+a(4,i,j)*x(i+1,j) )
         x(i,j)=tmp/a(3,i,j)

         do i=2,nxm1
            tmp=f(i,j)-( a(1,i,j)*x(i,jm1)+a(2,i,j)*x(i-1,j)
     &                  +a(4,i,j)*x(i+1,j) )
            x(i,j)=tmp/a(3,i,j)
         end do

         i=nx
         tmp=f(i,j)-( a(1,i,j)*x(i,jm1)+a(2,i,j)*x(i-1,j) )
         x(i,j)=tmp/a(3,i,j)

         if (id_sgs.eq.1) then
c------  backward Gauss-Seidel

         j=ny
         jm1=j-1

         i=nx
         tmp=f(i,j)-( a(1,i,j)*x(i,jm1)+a(2,i,j)*x(i-1,j) )
         x(i,j)=tmp/a(3,i,j)

         do i=nxm1,2,-1
            tmp=f(i,j)-( a(1,i,j)*x(i,jm1)+a(2,i,j)*x(i-1,j)
     &                  +a(4,i,j)*x(i+1,j) )
            x(i,j)=tmp/a(3,i,j)
         end do

         i=1
         tmp=f(i,j)-( a(1,i,j)*x(i,jm1)+a(4,i,j)*x(i+1,j) )
         x(i,j)=tmp/a(3,i,j)

         do j=nym1,2,-1
            jm1=j-1
            jp1=j+1

            i=nx
            tmp=f(i,j)-( a(1,i,j)*x(i,jm1)+a(2,i,j)*x(i-1,j)
     &                  +a(5,i,j)*x(i,jp1) )
            x(i,j)=tmp/a(3,i,j)

            do i=nxm1,2,-1
               tmp=f(i,j)-( a(1,i,j)*x(i,jm1)+a(2,i,j)*x(i-1,j)
     &                     +a(4,i,j)*x(i+1,j)+a(5,i,j)*x(i,jp1) )
               x(i,j)=tmp/a(3,i,j)
            end do

            i=1
            tmp=f(i,j)-( a(1,i,j)*x(i,jm1)
     &                  +a(4,i,j)*x(i+1,j)+a(5,i,j)*x(i,jp1) )
            x(i,j)=tmp/a(3,i,j)
         end do

         j=1
         jp1=j+1

         i=nx
         tmp=f(i,j)-( a(2,i,j)*x(i-1,j)+a(5,i,j)*x(i,jp1) )
         x(i,j)=tmp/a(3,i,j)

         do i=nxm1,2,-1
            tmp=f(i,j)-( a(2,i,j)*x(i-1,j)+a(4,i,j)*x(i+1,j)
     &                  +a(5,i,j)*x(i,jp1) )
            x(i,j)=tmp/a(3,i,j)
         end do

         i=1
         tmp=f(i,j)-( a(4,i,j)*x(i+1,j)+a(5,i,j)*x(i,jp1) )
         x(i,j)=tmp/a(3,i,j)

*         call adj_const(nx,ny,x)
      end if

c------------------------------------------------------
      end do
c------------------------------------------------------

      return
      end

c ======================================================================
      subroutine adj_const(nx,ny,x)
c ======================================================================
      real x(nx,ny)

      zero=0.0
      tmp=x(1,1)

      if (tmp.ne.zero) then
         do j=1,ny
         do i=1,nx
            x(i,j)=x(i,j)-tmp
         end do
         end do
      end if

      return
      end

