c ======================================================================
      subroutine reorder(imode,mx,my,ndmnx,ndmny,nx,ny,a,b)
c ======================================================================
      real a(mx,my,ndmnx,ndmny),b(nx,ny)

c imode=1: in=a; out=b; unify into one-subdomain case
c imode=2: in=b; out=a; transform the data for DDM setting

      if (imode.eq.1) then

c------ interface averaging
 
         ndmnxm1 = ndmnx-1
         ndmnym1 = ndmny-1
         half=0.5d0

         do jj = 1,ndmnym1
            jjp1 = jj+1
         do ii = 1,ndmnx
         do i  = 1,mx
            temp = half*( a(i,my,ii,jj)+a(i,1,ii,jjp1) )
            a(i,my,ii,jj) = temp
            a(i,1,ii,jjp1)= temp
         end do
         end do
         end do
 
         do jj = 1,ndmny
         do ii = 1,ndmnxm1
            iip1 = ii+1
         do j  = 1,my
            temp = half*( a(mx,j,ii,jj)+a(1,j,iip1,jj) )
            a(mx,j,ii,jj) = temp
            a(1,j,iip1,jj)= temp
         end do
         end do
         end do

c------ now, reordering

         do jj = 1,ndmny
            ntjj = (jj-1)*(my-1)
         do j  = 1,my
            ntty = ntjj+j
         do ii = 1,ndmnx
            ntii = (ii-1)*(mx-1)
         do i  = 1,mx
            nttx = ntii+i
            b(nttx,ntty)=a(i,j,ii,jj)
         end do
         end do
         end do
         end do

      else if (imode.eq.2) then

         do jj = 1,ndmny
            ntjj = (jj-1)*(my-1)
         do j  = 1,my
            ntty = ntjj+j
         do ii = 1,ndmnx
            ntii = (ii-1)*(mx-1)
         do i  = 1,mx
            nttx = ntii+i
            a(i,j,ii,jj)=b(nttx,ntty)
         end do
         end do
         end do
         end do

      else
         stop 'reorder.f: imode should be 1 or 2.'
      end if

      return
      end

c ======================================================================
      subroutine projection(imode,idgrid,nnnx,nnny,nx,ny,a,b)
c ======================================================================
      real a(nnnx,nnny),b(nx,ny)
      real sf(0:16)

c imode=1: in=a; out=b; restriction
c imode=2: in=b; out=a; prolongation
 
      if(idgrid.eq.1)then
          if(imode.eq.1)then
              do j=1,ny
              do i=1,nx
                 b(i,j)=a(i,j)
              enddo
              enddo
          else
              do j=1,ny
              do i=1,nx
                 a(i,j)=b(i,j)
              enddo
              enddo
          endif
          return
      endif

!---------------------------------------

      nxm1=nx-1
      nym1=ny-1
      idm1=idgrid-1

      tmp =1.0/real(idgrid)
      do k=0,idgrid
         sf(k)=real(idgrid-k)*tmp
      end do

c--------------------------------------
      if (imode.eq.1) then
c--------------------------------------

         do j=1,ny
            ky = idgrid*(j-1)+1
         do i=1,nx
            kx = idgrid*(i-1)+1

c------ vertex contributions

            dick=a(kx,ky)

c------ edge contributions

            if (i.ne.nx) then
               do ik = 1,idm1
                  dick=dick+sf(ik)*a(kx+ik,ky)
               end do
            end if

            if (i.ne.1) then
               do ik = 1,idm1
                  dick=dick+sf(ik)*a(kx-ik,ky)
               end do
            end if

            if (j.ne.ny) then
               do jk = 1,idm1
                  dick=dick+sf(jk)*a(kx,ky+jk)
               end do
            end if

            if (j.ne.1) then
               do jk = 1,idm1
                  dick=dick+sf(jk)*a(kx,ky-jk)
               end do
            end if

c------ 1st quadrant

            if (i.ne.nx .and. j.ne.ny) then
               do jk = 1,idm1
               do ik = 1,idm1
                  dick=dick+sf(ik)*sf(jk)*a(kx+ik,ky+jk)
               end do
               end do
            end if

c------ 2nd quadrant

            if (i.ne.1 .and. j.ne.ny) then
               do jk = 1,idm1
               do ik = 1,idm1
                  dick=dick+sf(ik)*sf(jk)*a(kx-ik,ky+jk)
               end do
               end do
            end if

c------ 3rd quadrant

            if (i.ne.1 .and. j.ne.1) then
               do jk = 1,idm1
               do ik = 1,idm1
                  dick=dick+sf(ik)*sf(jk)*a(kx-ik,ky-jk)
               end do
               end do
            end if

c------ 4th quadrant

            if (i.ne.nx .and. j.ne.1) then
               do jk = 1,idm1
               do ik = 1,idm1
                  dick=dick+sf(ik)*sf(jk)*a(kx+ik,ky-jk)
               end do
               end do
            end if

         b(i,j)=dick

         end do
         end do

c--------------------------------------
      else if (imode.eq.2) then
c--------------------------------------

         do j=1,nym1
            nty1 = idgrid*(j-1)+1
            jp1=j+1
         do i=1,nxm1
            ntx1=idgrid*(i-1)+1
            do jk = 0,idm1
              aaa=sf(idgrid-jk)*b(i,  jp1)+sf(jk)*b(i,  j)
              bbb=sf(idgrid-jk)*b(i+1,jp1)+sf(jk)*b(i+1,j)
              ntty = nty1+jk
            do ik = 0,idm1
              nttx = ntx1+ik
              a(nttx,ntty)=sf(idgrid-ik)*bbb+sf(ik)*aaa
            end do
            end do
         end do
         end do
 
         i=nx
         nttx=nnnx
         do j = 1,nym1
            nty1=idgrid*(j-1)+1
         do jk= 0,idm1
            ntty = nty1+jk
            a(nttx,ntty)=sf(idgrid-jk)*b(i,j+1)+sf(jk)*b(i,j)
         end do
         end do
 
         j=ny
         ntty=nnny
         do i = 1,nxm1
            ntx1 = idgrid*(i-1)+1
         do ik= 0,idm1
            nttx = ntx1+ik
            a(nttx,ntty)=sf(idgrid-ik)*b(i+1,j)+sf(ik)*b(i,j)
         end do
         end do

         a(nnnx,nnny) = b(nx,ny)

c--------------------------------------
      else
         stop 'projection.f: imode should be 1 or 2.'
      end if

      return
      end

c ======================================================================
      subroutine residual(nx,ny,a,x,f,res,r8norm,r2norm)
c ======================================================================
      real a(5,nx,ny),x(nx,ny),f(nx,ny),res(nx,ny)

c---- res = f - a x

      nxm1=nx-1
      nym1=ny-1

c---- interior points

      do j=2,nym1
         jm1=j-1
         jp1=j+1
      do i=2,nxm1
         axij=a(1,i,j)*x(i,jm1)+a(2,i,j)*x(i-1,j)+a(3,i,j)*x(i,j)
     &       +a(4,i,j)*x(i+1,j)+a(5,i,j)*x(i,jp1)
         res(i,j)=f(i,j)-axij
      end do
      end do

c---- four corners

      i=1
      j=1
      axij=a(3,i,j)*x(i,j)+a(4,i,j)*x(i+1,j)+a(5,i,j)*x(i,j+1)
      res(i,j)=f(i,j)-axij

      i=nx
      j=1
      axij=a(3,i,j)*x(i,j)+a(2,i,j)*x(i-1,j)+a(5,i,j)*x(i,j+1)
      res(i,j)=f(i,j)-axij

      i=1
      j=ny
      axij=a(3,i,j)*x(i,j)+a(1,i,j)*x(i,j-1)+a(4,i,j)*x(i+1,j)
      res(i,j)=f(i,j)-axij

      i=nx
      j=ny
      axij=a(3,i,j)*x(i,j)+a(1,i,j)*x(i,j-1)+a(2,i,j)*x(i-1,j)
      res(i,j)=f(i,j)-axij

c---- four sides

      i=1
      do j=2,nym1
         axij=a(1,i,j)*x(i,j-1)+a(3,i,j)*x(i,j)
     &       +a(4,i,j)*x(i+1,j)+a(5,i,j)*x(i,j+1)
         res(i,j)=f(i,j)-axij
      end do

      i=nx
      do j=2,nym1
         axij=a(1,i,j)*x(i,j-1)+a(2,i,j)*x(i-1,j)+a(3,i,j)*x(i,j)
     &       +a(5,i,j)*x(i,j+1)
         res(i,j)=f(i,j)-axij
      end do

      j=1
      do i=2,nxm1
         axij=a(2,i,j)*x(i-1,j)+a(3,i,j)*x(i,j)
     &       +a(4,i,j)*x(i+1,j)+a(5,i,j)*x(i,j+1)
         res(i,j)=f(i,j)-axij
      end do

      j=ny
      do i=2,nxm1
         axij=a(1,i,j)*x(i,j-1)+a(2,i,j)*x(i-1,j)+a(3,i,j)*x(i,j)
     &       +a(4,i,j)*x(i+1,j)
         res(i,j)=f(i,j)-axij
      end do

c---- check maximum norm of the residual

      r8norm=0.0
      r2norm=0.0

      do j=2,ny
      do i=2,nx
         r8norm=max(r8norm,abs(res(i,j)))
         r2norm=r2norm+res(i,j)**2
      end do
      end do

      r2norm=sqrt(r2norm)

      return
      end

c ======================================================================
      subroutine numer_anal(nx,ny,x,trueh,hx,hy,ax,ay,
     &          err8,evx8,evy8,err2,evx2,evy2)
c ======================================================================
      real x(nx,ny),trueh(nx,ny)

      nxm1=nx-1
      nym1=ny-1
      facx=0.5/hx
      facy=0.5/hy

c---- |u-u^h|/|u|

      utru8=0.0
      umuh8=0.0
      utru2=0.0
      umuh2=0.0

      do j=2,nym1
      do i=2,nxm1
         tmp1 = trueh(i,j)
         tmp2 = tmp1-x(i,j)
         utru8= max(utru8,abs(tmp1))
         umuh8= max(umuh8,abs(tmp2))
         utru2= utru2+tmp1**2
         umuh2= umuh2+tmp2**2
      end do
      end do

      err8=umuh8/utru8
      err2=sqrt(umuh2/utru2)

c---- |grad u-G(grad u^h)|/|grad u|

      dutx8=0.0
      duty8=0.0
      duex8=0.0
      duey8=0.0
      dutx2=0.0
      duty2=0.0
      duex2=0.0
      duey2=0.0

      do j=2,nym1
         py=float(j-1)*hy+ay
      do i=2,nxm1
         px=float(i-1)*hx+ax
         evux = ux(px,py)
         evuy = uy(px,py)
         evex = evux-(x(i+1,j)-x(i-1,j))*facx
         evey = evuy-(x(i,j+1)-x(i,j-1))*facy
         dutx8= max(dutx8,abs(evux))
         duty8= max(duty8,abs(evuy))
         duex8= max(duex8,abs(evex))
         duey8= max(duey8,abs(evey))
         dutx2= dutx2+evux**2
         duty2= duty2+evuy**2
         duex2= duex2+evex**2
         duey2= duey2+evey**2
      end do
      end do

      evx8 = duex8/dutx8
      evy8 = duey8/duty8
      evx2 = sqrt(duex2/dutx2)
      evy2 = sqrt(duey2/duty2)

      return
      end

