c ======================================================================
      subroutine adop(betah)
c ======================================================================
      include 'commons.h'
      real betah(nx,ny,2)
 
      hx2   = hx**2
      hy2   = hy**2
      hxohy = hx/hy
      hxohy2= hxohy**2
      halfhx=half*hx
      halfhy=half*hy
      
      mxm1  = mx-1
      mym1  = my-1
      ndmnxm1=ndmnx-1
      ndmnym1=ndmny-1

*      fac = 0.5
      fac = 0.3

c.... for the vertical interfaces

      do 1000 jj = 1,ny
         py = dble(jj-1)*hy+ay
      do 1200 ii = 1,ndmnxm1
         aaaa = dble(ii-1)*hhx+ax

         px = aaaa
         de = half*(aa(px,py)+aa(px+hx,py))
         rx = halfhx*b1(px,py)
         if(ii.eq.1) then
            iside= 1
            evxi = xi(px,py,iside)
            evcc = cc(px,py)+art_react
            temp = evxi**2
            thefac = fac*de/hx
            if (temp .le. (0.2*thefac)) evxi = thefac
            diag = two*(de-rx+hx*evxi)+evcc*hx2
            tmul = two*(de-rx)/diag
         else
            diag = de+(cc(px,py)+art_react)*hx2 -(rx-betah(ii-1,jj,1))
            tmul = (de-rx)/diag
         endif
 
         do k=2,mxm1
            px   = dble(k-1)*hx+aaaa
            aaxy = aa(px,py)
            dw   = de
            de   = half*(aaxy+aa(px+hx,py))
            rx   = halfhx*b1(px,py)
            diag = de+dw+(cc(px,py)+art_react)*hx2-tmul*(dw+rx)
            tmul = (de-rx)/diag
         end do

         dw = de
         rx = halfhx*b1(px+hx,py)
         betah(ii,jj,1)= (dw+rx)*(one-tmul)

 1200 continue
 1000 continue
 
c.... for the horizontal interfaces
 
      do 2000 ii = 1,nx
         px = dble(ii-1)*hx+ax
      do 2200 jj = 1,ndmnym1
         bbbb = dble(jj-1)*hhy+ay

         py = bbbb
         dn = half*(aa(px,py)+aa(px,py+hy))
         ry = halfhy*b2(px,py)
         if(jj.eq.1) then
            iside= 3
            evxi = xi(px,py,iside)
            evcc = cc(px,py)+art_react
            temp = evxi**2
            thefac = fac*dn/hy
            if (temp .le. (0.2*thefac)) evxi = thefac
            diag = two*(dn-ry+hy*evxi)+evcc*hy2
            tmul = two*(dn-ry)/diag
         else
            diag = dn+(cc(px,py)+art_react)*hy2 -(ry-betah(ii,jj-1,2))
            tmul = (dn-ry)/diag
         endif
 
         do k=2,mym1
            py   = dble(k-1)*hy+bbbb
            aaxy = aa(px,py)
            ds   = dn
            dn   = half*(aaxy+aa(px,py+hy))
            ry   = halfhy*b2(px,py)
            diag = dn+ds+(cc(px,py)+art_react)*hy2-tmul*(ds+ry)
            tmul = (dn-ry)/diag
         end do

         ds = dn
         ry = halfhy*b2(px,py+hy)
         betah(ii,jj,2)= (ds+ry)*(one-tmul)

 2200 continue
 2000 continue

c.... scale y-directional parameters by the factor (hx/hy)^2

      do jj = 1,ndmnym1
      do ii = 1,nx
         betah(ii,jj,2) = betah(ii,jj,2)*hxohy2
      end do
      end do

      return
      end

c=====================================================================
      subroutine discret(a,betah)
c=====================================================================
      include 'commons.h'
      common /c4coef01/ hx2,hxohy,hxohy2
      common /c4coef02/ de,dw,dn,ds,rx,ry,diag
      common /c4coef03/ odx1,odx2,ody1,ody2
      real a(-mx:mx,mx,my,ndmnx,ndmny),betah(1)
 
      hx2   = hx**2
      hxohy = hx/hy
      hxohy2= hxohy**2
      imode = 2
 
      do jj=1,ndmny
      do ii=1,ndmnx
      do j =1,my
      do i =1,mx
      do k =-mx,mx
         a(k,i,j,ii,jj)= 0.0
      end do
      end do
      end do
      end do
      end do

      do jj=1,ndmny
      do ii=1,ndmnx

         do j=1,my
         do i=1,mx
            call setcoef(i,j,ii,jj,betah,imode)
            a(-mx,i,j,ii,jj) = ody2*(ds+ry)
            a(-1, i,j,ii,jj) = odx2*(dw+rx)
            a(0,  i,j,ii,jj) = diag
            a(1,  i,j,ii,jj) = odx1*(de-rx)
            a(mx, i,j,ii,jj) = ody1*(dn-ry)
         end do
         end do

      end do
      end do
 
      return
      end

c ======================================================================
      subroutine setcoef(i,j,ii,jj,betah,imode)
c ======================================================================
      include 'commons.h'
      common /c4coef01/ hx2,hxohy,hxohy2
      common /c4coef02/ de,dw,dn,ds,rx,ry,diag
      common /c4coef03/ odx1,odx2,ody1,ody2
      real betah(nx,ny,2)
 
      px  = float(ii-1)*hhx+float(i-1)*hx+ax
      py  = float(jj-1)*hhy+float(j-1)*hy+ay

      tt  = aa(px,py)
      de  = 0.5*(tt+aa(px+hx,py))
      dw  = 0.5*(tt+aa(px-hx,py))
      dn  = 0.5*(tt+aa(px,py+hy))*hxohy2
      ds  = 0.5*(tt+aa(px,py-hy))*hxohy2
      rx  = 0.5*hx*b1(px,py)
      ry  = 0.5*hx*b2(px,py)*hxohy

      if (imode.lt.2) return
c----------------------------------

      odx1= -one
      odx2= -one
      ody1= -one
      ody2= -one
 
      bx1 = zero
      bx2 = zero
      by1 = zero
      by2 = zero

      if (i.eq.1) then
         odx2= zero
         if (ii.eq.1) then
            dw  =de
            odx1=-two
            bx1 =-two*rx+xi(px,py,1)*two*hx
         else
            ngj = (jj-1)*(my-1)+j
            bx1 =-(dw+rx-betah(ii-1,ngj,1))
         end if
      else if (i.eq.mx) then
         odx1= zero
         if (ii.eq.ndmnx) then
            de  =dw
            odx2=-two
            bx2 = two*rx+xi(px,py,2)*two*hx
         else
            ngj = (jj-1)*(my-1)+j
            bx2 =-(de-rx-betah(ii,ngj,1))
         end if
      end if

      if (j.eq.1) then
         ody2= zero
         if (jj.eq.1) then
            ds  =dn
            ody1=-two
            by1 =-two*ry+xi(px,py,3)*two*hx*hxohy
         else
            ngi = (ii-1)*(mx-1)+i
            by1 =-(ds+ry-betah(ngi,jj-1,2))
         end if
      else if (j.eq.my) then
         ody1= zero
         if (jj.eq.ndmny) then
            dn  =ds
            ody2=-two
            by2 = two*ry+xi(px,py,4)*two*hx*hxohy
         else
            ngi = (ii-1)*(mx-1)+i
            by2 =-(dn-ry-betah(ngi,jj,2))
         end if
      end if

c----------------------------------

      diag=de+dw+ds+dn +(cc(px,py)+art_react)*hx2 +bx1+bx2+by1+by2

      return
      end

c=======================================================================
      subroutine ludecom_ddm(mx,lneqn,ndmnx,ndmny,A)
c=======================================================================
      real A(-mx:mx,lneqn,ndmnx,ndmny)
 
      do jj=1,ndmny
      do ii=1,ndmnx
         call ludecom(mx,lneqn,A(-mx,1,ii,jj))
      end do
      end do
 
      return
      end

c=======================================================================
      subroutine ludecom(mx,lneqn,A)
c=======================================================================
      real A(-mx:mx,lneqn)

      zero=0.0

       do 10 k=1,lneqn
          kb = min(lneqn-k,mx)
          do 20 i= 1, kb
             kpi = k+i
             dick= A(-i,kpi)
             if(dick.eq.zero) goto 20
             cunt= dick/A(0,k)
             A(-i,kpi) = cunt
             do j= 1, kb
                A(j-i,kpi)= A(j-i,kpi)-cunt*A(j,k)
             end do
 20       continue
 10    continue

      return
      end

c=======================================================================
      subroutine substit_ddm(mx,lneqn,ndmnx,ndmny,A,x)
c=======================================================================
      real A(-mx:mx,lneqn,ndmnx,ndmny),x(lneqn,ndmnx,ndmny)
 
      do jj=1,ndmny
      do ii=1,ndmnx
         call substit(mx,lneqn,A(-mx,1,ii,jj),x(1,ii,jj))
      end do
      end do
 
      return
      end

c=======================================================================
      subroutine substit(mx,lneqn,A,x)
c=======================================================================
      real A(-mx:mx,lneqn),x(lneqn)
 
      do k=2,lneqn
         kb   = min(k-1,mx)
         do j= 1, kb
            x(k) = x(k) - A(-j,k)*x(k-j)
         end do
      end do

      x(lneqn) = x(lneqn)/A(0,lneqn)
      do k= lneqn-1, 1, -1
         kb= min(lneqn-k,mx)
         do j= 1,kb
            x(k) = x(k) - A(j,k)*x(k+j)
         end do
         x(k) = x(k)/A(0,k)
      end do  

      return
      end

