c=======================================================================
      real function aa(x,y)
c=======================================================================
      include 'commons.h'

      if (ndiffmod10.eq.1) then
         aa = 1.0
      else if (ndiffmod10.eq.2) then
         tmp= 6.*pi/(by-ay)
         aa = 2.0+cos(tmp*(x-ay)) +ay**2*(3.*by-ay)
     &          -y*(2.*y*y-3.*(ay+by)*y+6.*ay*by)
      else if (ndiffmod10.eq.3) then
         aa = one/(one+c4diff*(x*x+y*y))
      else if (ndiffmod10.eq.4) then
         temp=(ax+bx+hhhx)*0.5
         if(x.lt.temp) then
            aa=0.5*(1.+abs(cos(20.*x**2)))
         else
            aa=1.0/(1.+2.0*abs(sin(10.*x+15.*y**2)))
         endif
      else
         aa = 1.0
      endif

      return
      end

c=======================================================================
      real function aax(x,y)
c=======================================================================
      include 'commons.h'

      if (ndiffmod10.eq.1) then
         aax = 0.0
      else if (ndiffmod10.eq.2) then
         tmp = 6.*pi/(by-ay)
         aax = -tmp*sin(tmp*(x-ay))
      else if (ndiffmod10.eq.3) then
         aax = -2.0*c4diff*x/(one+c4diff*(x*x+y*y))**2
      else
         aax = 0.0
      endif

      return
      end

c=======================================================================
      real function aay(x,y)
c=======================================================================
      include 'commons.h'

      if (ndiffmod10.eq.1) then
         aay = 0.0
      else if (ndiffmod10.eq.2) then
         aay = 6.*(y-ay)*(by-y)
      else if (ndiffmod10.eq.3) then
         aay = -2.0*c4diff*y/(one+c4diff*(x*x+y*y))**2
      else
         aay = 0.0
      endif

      return
      end

c=======================================================================
      real function b1(x,y)
c=======================================================================
      include 'commons.h'

      if (ndiff.le.20) then
         b1 = 0.0
      else if (ndiffmod10.eq.1) then
         b1 = 2.0
      else if (ndiffmod10.eq.2) then
         b1 = 1.0d0 +x**2+y
      else
         b1 = 0.0
      endif

      return
      end

c=======================================================================
      real function b2(x,y)
c=======================================================================
      include 'commons.h'

      if (ndiff.le.20) then
         b2 = 0.0
      else if (ndiffmod10.eq.1) then
         b2 = 1.0
      else if (ndiffmod10.eq.2) then
         b2 = 1.0 +x+y**2
      else
         b2 = 0.0
      endif

      return
      end

c=======================================================================
      real function cc(x,y)
c=======================================================================
      include 'commons.h'
      cc = c4react
      if (cc.ge.1.e-5) id_fixpoint=0
      return
      end

c=======================================================================
      real function gg(x,y,iside)
c=======================================================================
      include 'commons.h'
      goto(10,20,30,40),iside
 10   gg = -aa(x,y)*ux(x,y)+xi(x,y,iside)*true(x,y)
      return
 20   gg =  aa(x,y)*ux(x,y)+xi(x,y,iside)*true(x,y)
      return
 30   gg = -aa(x,y)*uy(x,y)+xi(x,y,iside)*true(x,y)
      return
 40   gg =  aa(x,y)*uy(x,y)+xi(x,y,iside)*true(x,y)
      return
      end

c=======================================================================
      real function xi(x,y,iside)
c=======================================================================
      include 'commons.h'
      if (ndiff.le.20) then
         xi = 0.0
      else if (iside.eq.1 .or. iside.eq.3) then
         xi = 1.0
      else
         xi = 0.0
      endif
      if (xi.ge.1.e-5) id_fixpoint=0
      return
      end

c=======================================================================
      real function true(x,y)
c=======================================================================
      include 'commons.h'
         true = sin(cox*x)*cos(coy*y)
      return
      end

c=======================================================================
      real function ux(x,y)
c=======================================================================
      include 'commons.h'
         ux = cox*cos(cox*x)*cos(coy*y)
      return
      end

c=======================================================================
      real function uy(x,y)
c=======================================================================
      include 'commons.h'
         uy = -coy*sin(cox*x)*sin(coy*y)
      return
      end

c=======================================================================
      real function r1prhs(x,y)
c=======================================================================
      include 'commons.h'
      r1prhs = (aa(x,y)*(cox**2+coy**2)+cc(x,y)) * true(x,y)
     &       + (b1(x,y)-aax(x,y))*ux(x,y) +(b2(x,y)-aay(x,y))*uy(x,y)
      return
      end

c=======================================================================
      subroutine rhstrue(rhs,truev)
c=======================================================================
      include 'commons.h'
      real rhs(mx,my,ndmnx,ndmny),truev(mx,my,ndmnx,ndmny)
 
      hh    = hx**2
      hxohy = hx/hy
      twohx = 2.0d0*hx

      if (id_point_src.eq.1) goto 3000

      do 2000 jj=1,ndmny
          bbbb  = dble(jj-1)*hhy+ay
      do 1000 ii=1,ndmnx
          aaaa  = dble(ii-1)*hhx+ax
 
          do j = 1,my
              py = hy*dble(j-1)+bbbb
          do i = 1,mx
              px = hx*dble(i-1)+aaaa
              rhs(i,j,ii,jj)  = r1prhs(px,py)*hh
              truev(i,j,ii,jj)= true(px,py)
          end do
          end do
 
          if(ii.eq.1) then
              iside= 1
              px=ax
              i=1
              do j=1,my
                  py = hy*dble(j-1)+bbbb
                  rhs(i,j,ii,jj)=rhs(i,j,ii,jj)+twohx*gg(px,py,iside)
              end do
          endif
 
          if(ii.eq.ndmnx) then
              iside=2
              px=bx
              i=mx
              do j=1,my
                  py = hy*dble(j-1)+bbbb
                  rhs(i,j,ii,jj)=rhs(i,j,ii,jj)+twohx*gg(px,py,iside)
              end do
          endif
     
          if(jj.eq.1) then
              iside=3
              py=ay
              j=1
              do i=1,mx
                  px = dble(i-1)*hx+aaaa
                  rhs(i,j,ii,jj)=rhs(i,j,ii,jj)
     &                          +twohx*gg(px,py,iside)*hxohy
              end do
          endif
 
          if(jj.eq.ndmny) then
              iside= 4
              py=by
              j=my
              do i=1,mx
                  px = dble(i-1)*hx+aaaa
                  rhs(i,j,ii,jj)=rhs(i,j,ii,jj)
     &                          +twohx*gg(px,py,iside)*hxohy
              end do
          endif

 1000 continue
 2000 continue
      goto 9999

 3000 continue

      do jj=1,ndmny
      do ii=1,ndmnx
      do j =1,my
      do i =1,mx
         rhs(i,j,ii,jj)=0.0
      end do
      end do
      end do
      end do

      ixend=max(1,16/ndmnx)
      iyend=max(1,8/ndmny)
      nsrc=0
      nsink=0

      do jj=1,ndmny
      do ii=1,ndmnx
         do iy=1,iyend
         do ix=1,ixend

            i=mod((ii*3+jj*7 +ix),(mx-2))+2
            j=mod((ii*5+jj*11+ii*jj*3),(my-2))+2
            magn=mod((3*ii+11*jj+i+j),7)-3

            kx=(ii-1)*(mx-1)+i
            ky=(jj-1)*(my-1)+j
            if(kx.lt.(nx/20) .or. kx.gt.(nx-nx/20)) magn=0
            if(ky.lt.(ny/20) .or. ky.gt.(ny-ny/20)) magn=0

            if (abs(magn).gt.1) then
               rhs(i,j,ii,jj) = float(magn)*0.75
               if(magn.gt.0) nsrc=nsrc+1
               if(magn.lt.0) nsink=nsink+1
            end if

         end do
         end do
      end do
      end do

      print'(" Number of sources & sinks  =",2(i5))',nsrc,nsink

 9999 return
      end

c=======================================================================
      subroutine iguess(x,n,val)
c=======================================================================
      real x(n)
 
      do i=1,n
         x(i)=val
      end do
 
      return
      end

