      program main

      real, allocatable :: a(:),x(:),rhs(:),betah(:),truev(:)
      real, allocatable :: ah(:),xh(:),fh(:),trueh(:),res(:)
      real, allocatable :: wksp(:),xh2(:)

      include 'commons.h'

      call readata

      allocate( a((2*mx+1)*neqn) )
      allocate( x(neqn*2) )
      allocate( rhs(neqn) )
      allocate( betah(nx*ny*2) )
      allocate( truev(neqn) )
      allocate( ah(5*nnnx*nnny) )
      allocate( xh(nnnx*nnny) )
      allocate( fh(nnnx*nnny) )
      allocate( trueh(nnnx*nnny) )
      allocate( res(nnnx*nnny) )
      allocate( wksp(nx*ny) )
      !allocate( xh2(nnnx*nnny) )

      pi  = 4.0d0*datan(1.0d0)
      zero= 0.0d0
      half= 0.5d0
      one = 1.0d0
      two = 2.0d0
      four= 4.0d0
      eps = 1.0d-6

      id_fixpoint=1
 
! -----------------------------------------------
 
      if (idtrue.eq.1) then
         cox=17.*pi/(bx-ax)
         coy=13.*pi/(by-ay)
      end if

      call driv_2g(ah,xh,fh,trueh,res,a,x,rhs,truev,betah,wksp,id2)

      if (id_point_src.eq.1) then
         print'(" nsrc and nsink   =",2(i7)/)',nsrc,nsink
      else
         if(level.ge.1) then
             call numer_anal(nnnx,nnny,xh,trueh,hhhx,hhhy,ax,ay,&
                    err8,evx8,evy8,err2,evx2,evy2)
             print'(/" err8,evx8,evy8 =",3(1pe10.2) &
     &              /" err2,evx2,evy2 =",3(1pe10.2)/)', &
     &              err8,evx8,evy8,err2,evx2,evy2
         endif
      end if

      if(level.ge.3)then
         imode=3
         jump=1
         if (nnnx.gt.100) jump=2
         if (imode.ge.2 .and. nnnx.gt.300) jump=4
         call printdata(imode,jump,x,wksp,id2,xh,55)
      endif
 
!!========================================
!         c4react=20.0
!         call driv_2g(ah,xh2,fh,trueh,res,a,x,rhs,truev,betah,wksp,id2)
!
!         tmp1=0.0
!         tmp2=0.0
!         do i=1,nnnx*nnny
!            tmp1=max(tmp1,abs(xh(i)))
!            tmp2=max(tmp2,abs(xh(i)-xh2(i)))
!         end do
!         print'(" |u_0-u_",i2,"|/|u_0|=",f8.4)',int(art_react),tmp2/tmp1
!         do i=1,nnnx*nnny
!            xh(i)=(xh(i)-xh2(i))
!         end do
!
!         imode=3
!         call printdata(imode,jump,x,wksp,id2,xh,66)
!!========================================

! -----------------------------------------------
 
      stop
      end

! ============================================================
      subroutine readata
! ============================================================
      include 'commons.h'
      character*60 dummy

      nz=0
      nnnz=0
      ndmnz=0
      mz=0

      read (5,*) nnnx
      read (5,*) nnny
      read (5,*) idgrid
      read (5,*) ndmnx
      read (5,*) ndmny
        if(idgrid.le.0)then
           print*,"idgrid=",idgrid,": changed to be 1"
           idgrid=1
        endif
        nx = (nnnx-1)/idgrid+1
        ny = (nnny-1)/idgrid+1
        nnneqn=nnnx*nnny
 
      read*, dummy
      read (5,*) ndiff
      read (5,*) c4diff
      read (5,*) c4react
      read (5,*) art_react
      read (5,*) id_point_src
         ndiffmod10=mod((ndiff-1),10)+1
         idtrue=1
         if (id_point_src.eq.1) idtrue=0

      read*, dummy
      read (5,*) npcol
      read (5,*) tol
      read (5,*) tol2grid
      read (5,*) level
      read (5,*) itmax
      read (5,*) itmax2grid
      read (5,*) id_sgs
      read (5,*) itmax_smooth
      read (5,*) id_auto_smooth
        if((ndmnx*ndmny).le.1)itmax=1
        if(idgrid.le.1)then
           itmax2grid=0
           tol=tol2grid
           art_react=0.0
        end if
        if(id_auto_smooth.eq.1)then
           itmax_smooth=idgrid+2
        endif

      ax = 0.0d0
      bx = 1.0d0
      ay = 0.0d0
      by = 1.0d0

      read*, dummy
      read (5,*) ax
      read (5,*) bx
      read (5,*) ay
      read (5,*) by

      mx   = (nx-1)/ndmnx+1
      my   = (ny-1)/ndmny+1
      mmxy = max(mx,my)
      lneqn= mx*my
      neqn = lneqn*ndmnx*ndmny
      inorm= 8

      hhhx= (bx-ax)/dble(nnnx-1)
      hhhy= (bx-ax)/dble(nnny-1)
      hx  = (bx-ax)/dble(nx-1)
      hy  = (by-ay)/dble(ny-1)
      hhx = (bx-ax)/dble(ndmnx)
      hhy = (by-ay)/dble(ndmny)

      if(level.ge.2)then
         write(6,440) nnnx,nnny,nnnz
         write(6,442) nx,ny,nz
         write(6,443) ndmnx,ndmny,ndmnz
         write(6,444) mx,my,mz
         write(6,447) tol,tol2grid
         write(6,448) level,itmax
         write(6,470) itmax2grid,itmax_smooth
         write(6,449) ndiff
         write(6,450) c4diff
         write(6,455) c4react
         write(6,460) art_react
      endif

 440  format(1x,'nnnx, nnny, nnnz= ',i6,'  X ',i5,'  X ',i5)
 442  format(1x,'nx  X ny  X nz  = ',i6,'  X ',i5,'  X ',i5)
 443  format(1x,'ndx X ndy X ndz = ',i6,'  X ',i5,'  X ',i5)
 444  format(1x,'mx  X my  X mz  = ',i6,'  X ',i5,'  X ',i5)
 447  format(1x,'tol,tol2grid    = ',2(1pe10.2))
 448  format(1x,'level,itmax     = ',2i6)
 470  format(1x,'itmax2g,itmax_sm= ',2i6)
 449  format(1x,'ndiff           = ',i6)
 450  format(1x,'c4diff          = ',f10.5)
 455  format(1x,'c4react         = ',f10.5)
 460  format(1x,'art_react       = ',f10.5)

      return
      end

! ======================================================================
      subroutine printdata(imode,jump,x,wksp,id2,xh,iout)
! ======================================================================
      include 'commons.h'
      real x(neqn,1),wksp(nx,ny),xh(nnnx,nnny)
     
      goto (10,10,20) max(1,min(3,imode))

 10   continue

      open(55,file='uu_data')
      open(56,file='uu_info')

      if(imode.eq.1) then
         n1=nx
         n2=ny
         h1=hx
         h2=hy
         call reorder(1,mx,my,ndmnx,ndmny,nx,ny,x(1,id2),wksp)
         do i=1,nx,jump
            write(55,'(6(f12.6))') (wksp(i,j),j=1,ny,jump)
         end do
      else
         n1=nnnx
         n2=nnny
         h1=hhhx
         h2=hhhy
         do i=1,nnnx,jump
            write(55,'(6(f12.6))') (xh(i,j),j=1,nnny,jump)
         end do
         j=nnny/2
         write(11,'(6(f12.6))') (xh(i,j),i=1,nnnx)
         i=nnnx/2
         write(22,'(6(f12.6))') (xh(i,j),j=1,nnny)
      end if

      ix=(n1-1)/jump+1
      iy=(n2-1)/jump+1
      xe=ax+float(n1-1)*h1
      ye=ay+float(n2-1)*h2

      write(56,'(2(i6))')    ix,iy
      write(56,'(4(f10.4))') ax,xe,ay,ye
      write(56,'(4(i6))')    nsrc,nsink,nnnx,nnny

      close(55)
      close(56)

      goto 9999

 20   continue

      write(iout,'(2(i6))') ((nnnx-1)/jump+1),((nnny-1)/jump+1)
      do j=1,nnny,jump
         py=ay+hhhy*float(j-1)
      do i=1,nnnx,jump
         px=ax+hhhx*float(i-1)
         write(iout,'(3(f12.6))') px,py,xh(i,j)
      end do
      end do

 9999 return
      end

