#include "H1.h"

void getA1(np,nf1,nf2,level,iter,ierr,DATA,c0,c1,A)

    ITYPE np,nf1,nf2,level,iter,*ierr;
    DTYPE DATA[][2];
    ATYPE c0[],c1[],A[][nf1];

{
    ITYPE i,j,k;
    VTYPE sum,xk,yk,f2xk,tmp;

   /******************/
   /* User Interface */
   /******************/

    if(level>=1 && iter==1)
        printf("getA1: np=%d nf1=%d nf2=%d\n",np,nf1,nf2);


   /******************/
   /* Iinial Setting */
   /******************/


   /*********/
   /* Get A */
   /*********/

    for(i=0;i<nf1;i++)
    for(j=0;j<nf1;j++){

        sum=0.;
        for(k=0;k<np;k++){
            xk=DATA[k][0];
            sum+=(pow(xk,i+j));
        }
        A[i][j]=sum;

    }

   /*****************************/
   /* Get the Corresponding RHS */
   /*****************************/

    for(i=0;i<nf1;i++){
        sum=0.;
        for(k=0;k<np;k++){
            xk=DATA[k][0];
            yk=DATA[k][1];
            tmp=c0[nf1]+c0[nf1+1]*xk*xk;
            if(fabs(tmp)<1.e-5)
               f2xk=0.0;
            else
               f2xk=xk*xk/tmp;
            sum+=(pow(xk,i)*(yk-f2xk));
        }
        c1[i]=sum;
    }


   /*********/
   /* Print */
   /*********/

    if(level>=3 && iter==1)
        for(i=0;i<nf1;i++){
             for(j=0;j<nf1;j++) printf(" %10.2f",A[i][j]);
             printf(" | %10.2f\n",c1[i]);
        }

}


