#include "H1.h"

void curve537(idata,np,neqn,itMax,level,ierr,tol,DATA,A,c,wksp)

    ITYPE idata,np,neqn,itMax,level,*ierr;
    VTYPE *tol;
    DTYPE DATA[][2];
    ATYPE A[],c[][neqn],wksp[][np];

{
    ITYPE i,iter,id0,id1;
    ITYPE nf1,nf2;
    ITYPE level0;
    VTYPE err;

   /******************/
   /* User Interface */
   /******************/

    if(level>=1)
        printf("CURVE537: idata=%d np=%d neqn=%d\n",idata,np,neqn);
    if(level>=2)
        printf("  itMax=%d tol=%g\n",itMax,*tol);


   /******************/
   /* Iinial Setting */
   /******************/

    level0=3;

    nf2=2;
    nf1=neqn-nf2;

    if(nf1<1)
        {printf("Error: curve537.c: too small neqn=%d\n",neqn);
        *ierr=1; return; }

    for(i=0;i<neqn;i++) c[0][i]=0.0;

   /*****************************/
   /* Alternating Curve Fitting */
   /*****************************/

    for(iter=1;iter<=itMax;iter++){

        id0=((iter+1)%2);
        id1=((iter)%2);

        getA1(np,nf1,nf2,level0,iter,ierr,DATA,c[id0],&c[id1][0],A+0);

        /*----------------------*/
        /* Your implementation: */
        /*----------------------*/

        /* LU-factorization for A+0 */
        /* Forward and back substitution for c[id1]+0 */

        /* getA2(np,nf1,nf2,level0,iter,ierr,
                 DATA,c[id0],&c[id1][nf1],&A[nf1*nf1]); */

        /* LU-factorization for A+nf1*nf1 */
        /* Forward and back substitution for c[id1]+nf1 */

	/*-----------------------------*/
	/* End of Your implementation: */
	/*-----------------------------*/

       /*--- Stopping Criterion ---*/

        err=0.0;
        for(i=0;i<neqn;i++)
            err+=((c[id1][i]-c[id0][i])*(c[id1][i]-c[id0][i]));
        err=sqrt(err);
        if(err<*tol){
            printf("ITERATION: converges when iter=%d\n",iter);
            break;
        }

    }

   /*********/
   /* Print */
   /*********/

    if(level==0) return;

    if(iter>=itMax)
        printf("ITERATION: does not converge for iter=%d\n",itMax);

    printf(" C: ");
    for(i=0;i<neqn;i++) printf(" %8.2f",c[id1][i]);
    printf("\n");

}


