#include "H1.h"

void Curve_Fit(idata,np,neqn,idsol,itMax,level,ierr,
       tol,
       DATA,A,c,wksp)

    ITYPE idata,np,neqn,idsol,itMax,level,*ierr;
    VTYPE *tol;
    DTYPE DATA[][2];
    ATYPE A[],c[],wksp[];

{

    float utime0,stime0,utime1,stime1;

   /******************/
   /* User Interface */
   /******************/

    if(level>=1)
        printf("[1;7mCURVE_FIT:[m idata=%d np=%d neqn=%d idsol=%d\n",
                         idata,np,neqn,idsol);
    if(level>=2)
        printf("  itMax=%d tol=%g\n",itMax,*tol);

   /******************/
   /* Iinial Setting */
   /******************/


   /****************/
   /* Clock Begins */
   /****************/

    if(level>=1){
        #if defined (_IBMR2) || defined (AIX) || defined (hpux)
            etimef77(&utime0,&stime0);
        #else
            etimef77_(&utime0,&stime0);
        #endif
    }

   /****************/
   /* Call Solvers */
   /****************/

    if(idsol==1){

        curve537(idata,np,neqn,itMax,level,ierr,tol,DATA,A,c,wksp);

    }
    else
        {printf("Error: Curve_Fit.c: wrong idsol=%d\n",idsol);
        *ierr=1; return;}


   /********************/
   /* Then, Clock Ends */
   /********************/

    if(level==0) return;

    #if defined (_IBMR2) || defined (AIX) || defined (hpux)
        etimef77(&utime1,&stime1);
    #else
        etimef77_(&utime1,&stime1);
    #endif
    printf("[1;7mCURVE_FIT:[m ElapsedTime=%.4g\n",utime1-utime0);

   /*************/
   /* Print Out */
   /*************/

}


