!=======================================================================
      subroutine sol_sip(nt,nx,ny,idsol,idCU2,nb,nwA,level,ierr,neqn,
     &        at,bt,ax,bx,ay,by,epsilon,theta,
     &        ht,hx,hy,vel_max,scheme, itmax,alpha,tol,
     &        A1,A2,A5,A5I,U,ENO,vel,wksp,ws2)
!=======================================================================
      implicit none
      integer nt,nx,ny,idsol,idCU2,nb,nwA,level,ierr,neqn,itmax
      real*8  at,bt,ax,bx,ay,by,epsilon,theta,alpha,tol
      real*8  ht,hx,hy,vel_max
      real*8  A1(-nb:nb,0:nx,0:ny),A2(-nb:nb,0:ny,0:nx)
      real*8  A5(5,0:nx,0:ny),A5I(5,0:ny,0:nx)
      real*8  U(0:nx,0:ny,0:1),ENO(*),vel(2,0:nx,0:ny)
      real*8  wksp(0:nx,0:ny),ws2(0:ny,0:nx,0:1)
      character*40 scheme

!------------------------------------
!---- local variables
!------------------------------------

      integer i,j,k,n,id1,id2,ipjump
      integer mnxy,level0,AddU,iterST,iter_Total
      real*8  time,theta_ht,theta1_ht,eps0

!------------------------------------
!---- print out and basic setting
!------------------------------------

      if(level.ge.1)then
         print'("SOL-SIP: alpha=",f5.3,"; idsol=",i2,": ",a40)',
     &          alpha,idsol,scheme
      endif

      if(level.ge.3)then
         print*,"nx=",nx," ax=",ax," bx=",bx," hx=",hx
         print*,"ny=",ny," ay=",ay," by=",by," hy=",hy
         print*,"nt=",nt," at=",at," bt=",bt," ht=",ht
         print*,"vel_max=",vel_max," epsilon=",epsilon," theta=",theta
         print*,"itmax=",itmax," alpha=",alpha," tol=",tol
      endif

      level0=0
      eps0=1.d-6
      mnxy=max(nx,ny)
      theta_ht=theta*ht
      theta1_ht=(1.d0-theta)*ht
      iter_Total=0

      ipjump=max(1,((nt/10+49)/50)*50)

!------------------------------------
!---- get "A5"  and "A5I"
!------------------------------------

      do j=0,ny
      do i=0,nx
          A5(1,i,j)=theta_ht*A2(-1,j,i)
          A5(2,i,j)=theta_ht*A1(-1,i,j)
          A5(3,i,j)=theta_ht*(A1(0,i,j)+A2(0,j,i))+1.d0
          A5(4,i,j)=theta_ht*A1( 1,i,j)
          A5(5,i,j)=theta_ht*A2( 1,j,i)
      enddo
      enddo

      call sip_ilu((nx+1),(ny+1),level0,ierr,alpha,A5,A5I)

!====================================
!---- Time marching
!====================================
      do n=1,nt
!------------------------------------

          time=at+dble(n)*ht
          if(n.eq.1 .or. mod(n,ipjump).eq.0 .or. n.eq.nt) then
             if(level.ge.2) print*,"n=",n," t=",time
          endif

         do j=0,ny
         do i=0,nx
             ws2(j,i,0)=U(i,j,0)
         enddo
         enddo

         call setRHS1(1,nx,ny,mnxy,nx,ny,idCU2,nb,1,level,ierr,
     &       epsilon,hx,theta1_ht,
     &       vel,A1,U(0,0,0),wksp,ENO)

         call setRHS1(2,ny,nx,mnxy,nx,ny,idCU2,nb,0,level,ierr,
     &       epsilon,hy,theta1_ht,
     &       vel,A2,ws2(0,0,0),ws2(0,0,1),ENO)

         do j=0,ny
         do i=0,nx
             U(i,j,1)=wksp(i,j)+ws2(j,i,1)   ! right-hand side
             U(i,j,0)=U(i,j,1)               ! initial value
         enddo
         enddo

         call sip5(0,(nx+1),(ny+1),itmax,iterST,level0,ierr,
     &             alpha,tol,A5,A5I,U(0,0,0),U(0,0,1),wksp)

         if(ierr.ne.0)then
             print*,"Error: sol_SIP.f"
             return
         endif

         iter_Total=iter_Total+iterST

!------------------------------------
      enddo
!------------------------------------

      if(level.ge.2)then
          print*,"SIP:Total_Iter=",iter_Total
          print'(" SIP:Aver_Iter =",f6.2)',float(iter_Total)/float(nt)
      endif

      return
      end
