!=======================================================================
      subroutine sol_adi(nt,nx,ny,idsol,idCU2,nb,nwA,level,ierr,neqn,
     &        at,bt,ax,bx,ay,by,epsilon,theta,
     &        ht,hx,hy,vel_max,scheme,
     &        A1,A2,H,V,U,ENO,vel,wksp,ws2)
!=======================================================================
      implicit none
      integer nt,nx,ny,idsol,idCU2,nb,nwA,level,ierr,neqn
      real*8  at,bt,ax,bx,ay,by,epsilon,theta
      real*8  ht,hx,hy,vel_max
      real*8  A1(-nb:nb,0:nx,0:ny),A2(-nb:nb,0:ny,0:nx)
      real*8  H(-nb:nb,0:nx,0:ny),V(-nb:nb,0:ny,0:nx)
      real*8  U(0:nx,0:ny,0:1),ENO(*),vel(2,0:nx,0:ny)
      real*8  wksp(neqn,*),ws2(0:ny,0:nx,0:1)
      character*40 scheme

!------------------------------------
!---- local variables
!------------------------------------

      integer i,j,k,n,id1,id2,ipjump
      integer mnxy,level0,AddU
      real*8  time,theta_ht,theta1_ht,eps0

!------------------------------------
!---- print out and basic setting
!------------------------------------

      if(level.ge.1)then
         print'("SOL-ADI: idsol=",i2,": ",a40)',idsol,scheme
      endif

      if(level.ge.3)then
         print*,"nx=",nx," ax=",ax," bx=",bx," hx=",hx
         print*,"ny=",ny," ay=",ay," by=",by," hy=",hy
         print*,"nt=",nt," at=",at," bt=",bt," ht=",ht
         print*,"vel_max=",vel_max," epsilon=",epsilon," theta=",theta
      endif

      level0=0
      eps0=1.d-6
      mnxy=max(nx,ny)
      theta_ht=theta*ht
      theta1_ht=(1.d0-theta)*ht
      AddU=1

      ipjump=max(1,((nt/10+49)/50)*50)

!------------------------------------
!---- get "H"  and "V"
!------------------------------------

      do j=0,ny
      do i=0,nx
          do k=-nb,nb
              H(k,i,j)=theta_ht*A1(k,i,j)
          enddo
          H(0,i,j)=H(0,i,j)+1.d0
      enddo
      enddo

      do i=0,nx
      do j=0,ny
          do k=-nb,nb
              V(k,j,i)=theta_ht*A2(k,j,i)
          enddo
          V(0,j,i)=V(0,j,i)+1.d0
      enddo
      enddo

!------------------------------------
!---- LU-factorization of "H" and "V"
!------------------------------------

      do j=0,ny
          call lufac(nb,(nx+1),level0,H(-nb,0,j))
      enddo

      do i=0,nx
          call lufac(nb,(ny+1),level0,V(-nb,0,i))
      enddo

!-------------------------------------
!---- initial copy for operatoring A2
!-------------------------------------

      do j=0,ny
      do i=0,nx
          ws2(j,i,0)=U(i,j,0)
      enddo
      enddo


!====================================
!---- Time marching
!====================================
      do n=1,nt
!------------------------------------

          time=at+dble(n)*ht
          if(n.eq.1 .or. mod(n,ipjump).eq.0 .or. n.eq.nt) then
             if(level.ge.2) print*,"n=",n," t=",time
          endif

!-- X-SWEEP

         call setRHS1(2,ny,nx,mnxy,nx,ny,idCU2,nb,AddU,level,ierr,
     &       epsilon,hy,theta1_ht,
     &       vel,A2,ws2(0,0,0),ws2(0,0,1),ENO)

         do j=0,ny
         do i=0,nx
             U(i,j,1)=ws2(j,i,1)
         enddo
         enddo

         if(theta.ge.eps0)then
             do j=0,ny
                 call substit(nb,(nx+1),level0,H(-nb,0,j),U(0,j,1))
             enddo
         endif

!-- Y-SWEEP

         call setRHS1(1,nx,ny,mnxy,nx,ny,idCU2,nb,AddU,level,ierr,
     &       epsilon,hx,theta1_ht,
     &       vel,A1,U(0,0,1),U(0,0,0),ENO)

         do j=0,ny
         do i=0,nx
             ws2(j,i,0)=U(i,j,0)
         enddo
         enddo

         if(theta.ge.eps0)then
             do i=0,nx
                 call substit(nb,(ny+1),level0,V(-nb,0,i),ws2(0,i,0))
             enddo
         endif

!------------------------------------
      enddo

      do j=0,ny
      do i=0,nx
          U(i,j,0)=ws2(j,i,0)
      enddo
      enddo

      return
      end
