!=======================================================================
      subroutine setRHS1(idir,nx,ny,mnxy,n1,n2,idCU2,nb,AddU,level,ierr,
     &       epsilon,hx,theta1_ht, vel,F,U0,U1,ENO)
!=======================================================================
      implicit none
      integer idir,nx,ny,mnxy,n1,n2,idCU2,nb,AddU,level,ierr
      real*8  epsilon,hx,theta1_ht
      real*8  vel(2,0:n1,0:n2)        ! direction-dependent only
      real*8  F(-nb:nb,0:nx,0:ny),U0(0:nx,0:ny),U1(0:nx,0:ny)
      real*8  ENO(0:mnxy,*)

!------------------------------------
!---- local variables
!------------------------------------

      integer i,j,k,nxm1
      integer ieno1,ieno2
      real*8  a,b,v,zero,one,two
      real*8  halfhx,epsOhx2,fac

      nxm1=nx-1
      zero=0.d0
      one =1.d0
      two =2.d0
      halfhx=0.5d0*hx
      epsOhx2=epsilon/(hx*hx)

!----------------

      do j=0,ny

          call D1(nx,1,hx,U0(0,j),ENO(0,1))
          call D1(nx,-1,hx,ENO(0,1),ENO(0,2))

          i=0
          U1(i,j)=F(0,i,j)*U0(i,j) +F(1,i,j)*U0(i+1,j)

          do 1000 i=1,nxm1

              if(idir.eq.1)then
                  v=vel(1,i,j)
              else
                  v=vel(2,j,i)
              endif
              if(v.ge.zero) then
                  ieno1=i-1
                  fac=halfhx
              else
                  ieno1=i+1
                  fac=-halfhx
              endif
              ieno2=min(i,ieno1)

              a=ENO(i,2)
              b=ENO(ieno1,2)

              if(idCU2.eq.1)then
                  if((a*b).le.zero)then
                      U1(i,j)=v*ENO(ieno2,1)
     &                    +epsOhx2*(-U0(i-1,j)+two*U0(i,j)-U0(i+1,j))
                      goto 1000
                  endif
              endif

              if(dabs(a).le.dabs(b))then
                  U1(i,j)=F(-1,i,j)*U0(i-1,j)
     &                   +F(0,i,j)*U0(i,j) +F(1,i,j)*U0(i+1,j)
              else
                  U1(i,j)=v*( ENO(ieno2,1) +fac*b )
     &                   +epsOhx2*(-U0(i-1,j)+two*U0(i,j)-U0(i+1,j))
              endif

 1000     continue

          i=nx
          U1(i,j)=F(-1,i,j)*U0(i-1,j) +F(0,i,j)*U0(i,j)

      enddo

!----------------

      if(AddU.eq.1)then
          do j=0,ny
          do i=0,nx
              U1(i,j)=U0(i,j)-theta1_ht*U1(i,j)
          enddo
          enddo
      else
          do j=0,ny
          do i=0,nx
              U1(i,j)=-theta1_ht*U1(i,j)
          enddo
          enddo
      endif

      return
      end

!=======================================================================
      subroutine D1(nx,id_eno,hx,u,Du)
!=======================================================================
      implicit none
      integer nx,id_eno
      real*8  hx,u(0:nx),Du(0:nx)

      integer i
      real*8  rhx
      rhx=1.d0/hx

      if(id_eno.eq.(-1))then
          do i=1,nx
              Du(i)=(u(i)-u(i-1))*rhx
          enddo
          Du(0)=Du(1)
      else if(id_eno.eq.1)then
          do i=0,nx-1
              Du(i)=(u(i+1)-u(i))*rhx
          enddo
          Du(nx)=Du(nx-1)
      else
          stop 'D1: error in id_eno'
      endif

      return
      end

