fid=fopen('fort.0');scheme=fscanf(fid,'%s');fclose(fid);

fid=fopen('fort.1');dim=fscanf(fid,'%f',[1,8]);fclose(fid);
nx=dim(1)
ax=dim(2); bx=dim(3); hx=dim(4);
ny=dim(5)
ay=dim(6); by=dim(7); hy=dim(8);

fid=fopen('fort.2');dim2=fscanf(fid,'%f',[1,7]);fclose(fid);
nt=dim(1)
at=dim(2); bt=dim(3); ht=dim(4);
theta=dim(5); sigma=dim(6); epsilon=dim(7); 

x=ax+(0:(nx-1))*hx;
y=ay+(0:(ny-1))*hy;

%============================================================
%% Computed solution
%============================================================

fid = fopen('fort.sol'); data0= fscanf(fid,'%f',[nx,ny]); fclose(fid);
data=transpose(data0);

colormap(hsv);
mesh(x,y,data); xlabel('X');ylabel('Y'); zlabel('U');
axis([0 1 0 1 0 1]); axis square;

%%%% Printing

if ( scheme == 'ENO2-ADI' & bt==1 & nx == 101 )
    title0='ENO2-ADI (T=1; Sigma=0.75; Dx=Dy=1/100)'
    title(title0);
    print -depsc ENO2-ADI.100.eps;
end
if ( scheme == 'ENO2-ADI' & bt==1 & nx == 201 )
    title0='ENO2-ADI (T=1; Sigma=0.75; Dx=Dy=1/200)'
    title(title0);
    print -depsc ENO2-ADI.200.eps;
end
if ( scheme == 'ENO2-ADI' & bt==5 & nx == 201 )
    title0='ENO2-ADI (T=5; Sigma=0.75; Dx=Dy=1/200)'
    title(title0);
    print -depsc ENO2-ADI.200.5.eps;
end

%print -depsc ENO2-ADI.100.eps;

