!=======================================================================
      subroutine matrix35(nx,ny,idsol,nb,level,ierr,
     &           ax,bx,ay,by,epsilon,vel,A1,A2)
!=======================================================================
      implicit none
      integer nx,ny,idsol,nb,level,ierr
      real*8 ax,bx,ay,by,epsilon
      real*8 vel(2,0:nx,0:ny),A1(-nb:nb,0:nx,0:ny),A2(-nb:nb,0:ny,0:nx)

! A1(-nb:nb,0:nx,0:ny)=v1*Ux-epsilon*Uxx
! A2(-nb:nb,0:ny,0:nx)=v2*Uy-epsilon*Uyy
    
      integer i,ix,iy
      real*8  hx,hy,zero,half
      real*8  twohx,twohy,rhx,rhy,r2hx,r2hy,r6hx,r6hy
      real*8  epsOhx2,epsOhy2,conv(-2:2)

      if(level.ge.1) then
          print'("MATRIX35: A1 & A2")'
      endif

      hx=(bx-ax)/dble(nx)
      hy=(by-ay)/dble(ny)

      twohx=2.d0*hx
      twohy=2.d0*hy
      rhx=1.d0/hx
      rhy=1.d0/hy
      r2hx=1.d0/(2.d0*hx)
      r2hy=1.d0/(2.d0*hy)
      r6hx=1.d0/(6.d0*hx)
      r6hy=1.d0/(6.d0*hy)

      epsOhx2=epsilon/(hx*hx)
      epsOhy2=epsilon/(hy*hy)
      zero=0.d0
      half=0.5d0


!-----------
!--- "A1"
!-----------

      do iy=0,ny
      do ix=0,nx
          call coefConv(idsol,nb,rhx,r2hx,r6hx,vel(1,ix,iy),conv)
          A1(-1,ix,iy)=conv(-1)     -epsOhx2
          A1( 0,ix,iy)=conv( 0)+2.d0*epsOhx2
          A1( 1,ix,iy)=conv( 1)     -epsOhx2
          if(nb.eq.2)then
              A1(-2,ix,iy)=conv(-2)
              A1( 2,ix,iy)=conv( 2)
          endif
      end do
      end do

!-----------
!--- "A2"
!-----------

      do ix=0,nx
      do iy=0,ny
          call coefConv(idsol,nb,rhy,r2hy,r6hy,vel(2,ix,iy),conv)
          A2(-1,iy,ix)=conv(-1)     -epsOhy2
          A2( 0,iy,ix)=conv( 0)+2.d0*epsOhy2
          A2( 1,iy,ix)=conv( 1)     -epsOhy2
          if(nb.eq.2)then
              A2(-2,iy,ix)=conv(-2)
              A2( 2,iy,ix)=conv( 2)
          endif
      end do
      end do

      return
      end

!=======================================================================
      subroutine coefConv(idsol,nb,rhx,r2hx,r6hx,vel,conv)
!=======================================================================
      implicit none
      integer idsol,nb
      real*8  rhx,r2hx,r6hx,vel,conv(-2:2)

      integer i
      real*8  zero

      zero=0.d0
      do i=-nb,nb
          conv(i)=zero
      enddo

      if(nb.eq.1)then

          conv( 1)= vel*r2hx
          conv(-1)=-vel*r2hx

      else 

          if(vel.ge.zero)then
              conv(-2)= vel*r6hx
              conv(-1)=-vel*r6hx*6.d0
              conv( 0)= vel*r6hx*3.d0
              conv( 1)= vel*r6hx*2.d0
          else
              conv(-1)=-vel*r6hx*2.d0
              conv( 0)=-vel*r6hx*3.d0
              conv( 1)= vel*r6hx*6.d0
              conv( 2)=-vel*r6hx
          endif

      endif

      return
      end

