c ======================================================================
      subroutine initU(nx,ny,n_init,level,ierr,at,ax,bx,ay,by,U)
c ======================================================================
      implicit none
      integer nx,ny,n_init,level,ierr
      real*8  at,ax,bx,ay,by,U(0:nx,0:ny)

      integer i,j,k,margin,ix1,ix2,iy1,iy2
      real*8  hx,hy,px,py,cx,cy,diam,tmp

      if(level.ge.1) print'("INIT_U: n_init=",i2)',n_init

!--------------------
!---- basic setting
!--------------------

      hx=(bx-ax)/dble(nx)
      hy=(by-ay)/dble(ny)

      do j=0,ny
      do i=0,nx
          U(i,j)=0.d0
      enddo
      enddo

!--------------------
!---- "U0"
!--------------------

*      goto (10,10,20),n_init

!-------------------
 10   continue
!-------------------
      if(level.eq.1) then
          print*,"U0=1, on a box region"
      else if(level.ge.3) then
          print'(/2x,"+",22("-"),"+",3(/2x,"|",22x,"|"),
     &         3(/2x,"|",14x,6("*"),"  |"),
     &         3(/2x,"|",22x,"|"),/2x,"+",22("-"),"+"/)'
      endif

      if(n_init.eq.1 .or. n_init.ge.5) then
          ix1=nint(0.6d0*(bx-ax)/hx)
          ix2=nint(0.8d0*(bx-ax)/hx)
          iy1=nint(0.6d0*(by-ay)/hy)
          iy2=nint(0.8d0*(by-ay)/hy)

          do j=iy1,iy2
          do i=ix1,ix2
              U(i,j)=1.d0
          enddo
          enddo
      endif

      if(n_init.ge.2 .or. n_init.ge.5)then
          cx=0.3d0
          cy=0.7d0
          diam=0.16d0

          do j=0,ny
              py=ay+dble(j)*hy
          do i=0,nx
              px=ax+dble(i)*hx
              tmp=dsqrt((cy-py)**2+(cx-px)**2)
              if(tmp.le.diam) U(i,j)=min(1.d0,1.1d0*(1.d0-tmp/diam))
          enddo
          enddo
      endif

      if(n_init.lt.3) goto 8888

!-------------------
 20   continue
!-------------------
      if(level.eq.1) then
          print*,"U0=1, on a Pi-shape region"
      else if(level.ge.3) then
          print'(2(/2x,12("Pi")),6(/6x,3("Pi"),4x,3("Pi"))/)'
      endif

      do k=1,3
          if(k.eq.1)then
              !-- Horizontal bar
              ix1=nint(0.25d0*(bx-ax)/hx)
              ix2=nint(0.75d0*(bx-ax)/hx)
              iy1=nint(0.3d0*(by-ay)/hy)
              iy2=nint(0.425d0*(by-ay)/hy)
          elseif(k.eq.2)then
              !-- the first vertical
              ix1=nint(0.30d0*(bx-ax)/hx)
              ix2=nint(0.45d0*(bx-ax)/hx)
              iy1=nint(0.1d0*(by-ay)/hy)
              iy2=nint(0.35d0*(by-ay)/hy)
          elseif(k.eq.3)then
              !-- the second vertical
              ix1=nint(0.55d0*(bx-ax)/hx)
              ix2=nint(0.70d0*(bx-ax)/hx)
              iy1=nint(0.1d0*(by-ay)/hy)
              iy2=nint(0.35d0*(by-ay)/hy)
          endif

          do j=iy1,iy2
          do i=ix1,ix2
              U(i,j)=1.0d0
          enddo
          enddo
      enddo


 8888 if(level.le.0) return

      open(68,file="fort.U0")
      print*,"<fort.U0>  contains  initial solution at t=",at
      do j=0,ny
      do i=0,nx
          write(68,*) U(i,j)
      enddo
      enddo
      close(68)


      return
      end

