!=======================================================================
      subroutine getvel(nx,ny,nvel,level,hx,hy,time,ax,bx,ay,by,vel)
!=======================================================================
      implicit none
      integer nx,ny,nvel,level
      real*8  hx,hy,time,ax,bx,ay,by
      real*8  vel(2,0:nx,0:ny)

      integer ix,iy
      real*8 px,py,cx,cy,pi
      real*8 freq
      common /t2freq/ freq

      freq=1.d0

!---- Interface

      if(level.ge.1)print'("GETVEL: nvel=",i1," freq=",f3.1)',nvel,freq
      if(level.ge.2) then
         print*,"nx=",nx," ny=",ny
         print*,"ax=",ax," bx=",bx
         print*,"ay=",ay," by=",by
         print*,"hx=",hx," hy=",hy
      endif

      cx=0.5d0*(ax+bx)
      cy=0.5d0*(ay+by)
      pi=4.d0*datan(1.d0)

      if(nvel.le.0 .or. nvel.ge.5)then
          stop 'Error: getvel.f: nvel must be 1 to 4.'
      endif

!--------------------------------------
      goto(10,20,30,40),nvel
!--------------------------------------

 10   continue
!---------------

      do iy=0,ny
         py=dble(iy)*hy+ay
      do ix=0,nx
         px=dble(ix)*hx+ax
         vel(1,ix,iy)=-2.d0*pi*(py-cy)
         vel(2,ix,iy)= 2.d0*pi*(px-cx)
      enddo
      enddo
      return

 20   continue
!---------------

      do iy=0,ny
         py=dble(iy)*hy+ay
      do ix=0,nx
         px=dble(ix)*hx+ax
         vel(1,ix,iy)=0.d0    ! Zero Velocity
         vel(2,ix,iy)=0.d0
      enddo
      enddo
      return

 30   continue
!---------------

      do iy=0,ny
         py=dble(iy)*hy+ay
      do ix=0,nx
         px=dble(ix)*hx+ax
         vel(1,ix,iy)=0.5d0
         vel(2,ix,iy)=dcos(pi*px)
*         vel(2,ix,iy)=freq*pi*dcos(freq*pi*px)
      enddo
      enddo
      return

 40   continue
!---------------

      do iy=0,ny
         py=dble(iy)*hy+ay
      do ix=0,nx
         px=dble(ix)*hx+ax
         vel(1,ix,iy)=2.d0
         vel(2,ix,iy)=2.d0*freq*pi*dcos(2.d0*freq*pi*time)
      enddo
      enddo
      return


      end

