!=======================================================================
      subroutine convection2D(nt,nx,ny,n_init,nvel,idsol,idCU2,nb,nwA,
     &     level,idnumer,ierr,neqn,auto_dt,itmax,
     &     at,bt,ax,bx,ay,by,epsilon,theta,sigma,alpha,tol,
     &     A1,A2,H,V,A5,U,ENO,vel,wksp,ws2,Uzero)
!=======================================================================
      implicit none
      integer nt,nx,ny,n_init,nvel,idsol,idCU2,nb,nwA
      integer level,idnumer,ierr,neqn,auto_dt,itmax
      real*8  at,bt,ax,bx,ay,by,epsilon,theta,sigma,alpha,tol
      real*8  A1(-nb:nb,0:nx,0:ny),A2(-nb:nb,0:ny,0:nx)
      real*8  H(-nb:nb,0:nx,0:ny),V(-nb:nb,0:ny,0:nx)
      real*8  A5(5,0:nx,0:ny,2)
      real*8  U(0:nx,0:ny,0:1),ENO(*),vel(2,0:nx,0:ny)
      real*8  wksp(neqn,*),ws2(neqn,*),Uzero(0:ny,0:nx)

!------------------------------------
!---- local variables
!------------------------------------

      integer i,j,k,n,id1,id2
      integer level0,level1,idsolmod10,iprx,ipry
      real*8  eps0,maxvec,theta_ht,px,py,tmp
      real*8  ht,hx,hy,vel_max,umax,umin,err1,err2,err8
      real*4  utime0,stime0,utime1,stime1
      character*40 scheme,pr1,pr2

!------------------------------------
!---- basic checking and setting
!------------------------------------

      call etimef77(utime0,stime0)

      eps0=1.d-6
      level0=0
      level1=min(level,1)

!-----------------

      scheme='NONE'
      if(idsol.eq.1) scheme='CU2-ADI'
      if(idsol.eq.2) scheme='CU2-SIP'

      if(scheme.ne.'NONE')then
          if(theta.le.eps0) scheme='CU2'
          if(idCU2.eq.0) scheme(1:3)='ENO'
      else
          print*,"Error: Convection2D.f: Wrong idsol"
          ierr=1
          return
      endif

!-----------------

      if( min(dabs(theta-0.0d0),dabs(theta-0.5d0),dabs(theta-1.0d0))
     &         .gt.eps0 ) then
          print*,"Error: Convection2D.f: theta=0.0, 0.5, or 1.0."
          ierr=1
          return
      endif

      hx=(bx-ax)/dble(nx)
      hy=(by-ay)/dble(ny)

      call getvel(nx,ny,nvel,level1,hx,hy,at,ax,bx,ay,by,vel)
      vel_max=maxvec(2,neqn,vel)
      if(vel_max.le.eps0)then
          print'(1x,20("-")/" Zero Velocity"/1x,20("-"))'
          if(idsol.le.3) scheme(1:4)='    '
          call getvel(nx,ny,1,0,hx,hy,at,ax,bx,ay,by,vel)
          vel_max=maxvec(2,neqn,vel)
          call getvel(nx,ny,nvel,0,hx,hy,at,ax,bx,ay,by,vel)
      endif

      if(auto_dt.eq.1) then
          nt=int((bt-at)*vel_max/(sigma*min(hx,hy)))+1
          ht=(bt-at)/dble(nt)
      else
          ht=(bt-at)/dble(nt)
          sigma=ht/min(hx,hy)*vel_max
      endif

      if( (theta.le.eps0 .and. sigma.gt.1.d0) .or.
     &    (idsol.eq.2 .and. theta.lt.eps0) )then
          print*,"sigma=",sigma
          print'(1x,40("-"))'
          print*,"Error: Convection2D.f: Stability violated."
          print'(1x,40("-"))'
          ierr=1
          return
      endif

!------------------------------------
!---- Print out information
!------------------------------------

      if(level.ge.1)then
         print'("CONVECTION_2D: idsol=",i2,": ",a40)',idsol,scheme
      endif

      if(level.ge.2)then
         print*,"nx=",nx," ax=",ax," bx=",bx," hx=",hx
         print*,"ny=",ny," ay=",ay," by=",by," hy=",hy
         print*,"nt=",nt," at=",at," bt=",bt," ht=",ht
         print*,"vel_max=",vel_max," epsilon=",epsilon," nwA=",nwA
         print*,"theta=",theta," sigma=",sigma
         print*,"itmax=",itmax," alpha=",alpha," tol=",tol
      endif


!------------------------------------
!---- get "A1" and "A2"
!------------------------------------

      call matrix35(nx,ny,idsol,nb,level1,ierr,
     &       ax,bx,ay,by,epsilon,vel,A1,A2)

      do j=0,ny
          call neumannBC(nx,nwA,level0,A1(-nb,0,j))
      enddo

      do i=0,nx
          call neumannBC(ny,nwA,level0,A2(-nb,0,i))
      enddo


!------------------------------------
!---- Set initial values
!------------------------------------

      call initU(nx,ny,n_init,level,ierr,at,ax,bx,ay,by,U)

      if(ierr.ne.0) then
          print*,"Error: convection2D.f: from initU"
          return
      endif

      if(idnumer.eq.1)then
          do j=0,ny
          do i=0,nx
              Uzero(i,j)=U(i,j,0)
          enddo
          enddo
      endif


!------------------------------------
!---- Call Solvers
!------------------------------------

      if(scheme(5:7).eq.'ADI')then

          call sol_adi(nt,nx,ny,idsol,idCU2,nb,nwA,level,ierr,neqn,
     &        at,bt,ax,bx,ay,by,epsilon,theta,
     &        ht,hx,hy,vel_max,scheme,
     &        A1,A2,H,V,U,ENO,vel,wksp,ws2)

      else if(scheme(5:7).eq.'SIP')then

          if(nb.ne.1) then
              print*,"Error: convection2D.f: nb.ne.1"
              ierr=1
              return
          endif

          call sol_sip(nt,nx,ny,idsol,idCU2,nb,nwA,level,ierr,neqn,
     &        at,bt,ax,bx,ay,by,epsilon,theta,
     &        ht,hx,hy,vel_max,scheme, itmax,alpha,tol,
     &        A1,A2,A5(1,0,0,1),A5(1,0,0,2),U,ENO,vel,wksp,ws2)

      endif


!------------------------------------
!---- Check error
!------------------------------------

      if(idnumer.eq.1)then
          err1=0.d0
          err2=0.d0
          err8=0.d0
          umin=100.0
          umax=-10.0
          do j=1,ny
          do i=1,nx
              err1=err1+dabs(Uzero(i,j)-U(i,j,0))
              err2=err2+(Uzero(i,j)-U(i,j,0))**2
              err8=max(err8,dabs(Uzero(i,j)-U(i,j,0)))
              umin=min(umin,U(i,j,0))
              umax=max(umax,U(i,j,0))
          enddo
          enddo
          err1=err1*hx*hy
          err2=dsqrt(err2*hx*hy)
      endif

!------------------------------------
!---- Print out the results
!------------------------------------

      if(level.le.0) return

      print'(40("-"))'
      print'("CONVECTION_2D: idsol=",i2,": ",a40)',idsol,scheme
      call etimef77(utime1,stime1)
      print'("Elapsed Time=",f7.2)',utime1-utime0

      print*,"sigma=",sigma," epsilon=",epsilon
      print*,"nt=",nt," ht=",ht," hx=",hx," hy=",hy
      if(scheme(5:7).eq.'SIP') then
          print*,"itmax=",itmax," alpha=",alpha," tol=",tol
      endif
      if(idnumer.eq.1) then
          print'(" err1=",1pe9.2,2x,"err2=",1pe9.2,2x,"err8=",1pe9.2)',
     &           err1,err2,err8
          print'(" Umin=",f9.6,2x,"Umax=",f9.6)',umin,umax

      endif

      open(1,file="fort.0")
         write(1,*) scheme
      close(1)
      open(1,file="fort.1")
         write(1,*) nx+1,ax,bx,hx,ny+1,ay,by,hy
      close(1)
      open(2,file="fort.2")
         write(2,*) nt,at,bt,ht,theta,sigma,epsilon
      close(2)

      open(68,file="fort.sol")
      print*,"<fort.sol> contains computed solution at t=",bt
      do j=0,ny
      do i=0,nx
          write(68,*) U(i,j,0)
      enddo
      enddo
      close(68)

      iprx=nint((1.d0/3.d0)*(bx-ax)/hx)
      ipry=nint((1.d0/4.d0)*(by-ay)/hy)
      if(nvel.eq.2) then
          pr1='fort.10'
          pr2='fort.20'
      else
          pr1='fort.11'
          pr2='fort.21'
      endif
      open(1,file=pr1)
      do i=0,nx
          px=ax+dble(i)*hx
          write(1,*) px,U(i,ipry,0)
      enddo
      close(1)
      open(2,file=pr2)
      do j=0,ny
          py=ay+dble(j)*hy
          write(2,*) py,U(iprx,j,0)
      enddo
      close(2)

      return
      end
