!=======================================================================
      subroutine numerical(nx,ny,nz,nbw,idnumer,iddirac,level,ierr,
     &            omega,ax,bx,ay,by,az,bz,hx,hy,hz,A,x,b,wksp)
!=======================================================================
      implicit none
      integer nx,ny,nz,nbw,idnumer,iddirac,level,ierr
      real*8  omega,ax,bx,ay,by,az,bz,hx,hy,hz
      complex*16 A(-nbw:nbw,0:nx,0:ny),x(0:nx,0:ny),b(0:nx,0:ny)
      complex*16 wksp(0:nx,0:ny)

      integer i,ix,iy,iz
      real*8 px,py,error
      complex*16 true,ctmp

!-----------------------

      error=0.d0

      open(68,file="fort.Ereal")
      open(69,file="fort.Eimag")
      do iy=0,ny
          py=ay+float(iy)*hy
      do ix=0,nx
          px=ax+float(ix)*hx
          ctmp=true(omega,px,py)-x(ix,iy)
          error=error+cdabs(ctmp)**2
          write(68,*) dreal(ctmp)
          write(69,*) dimag(ctmp)
      enddo
      enddo
      close(68)
      close(69)

      error=dsqrt(error/dble((nx+1)*(ny+1)))
      print'("L2Error=",1pe8.2)',error

      return
      end

