!=======================================================================
      subroutine mtx5vec(nx,ny,a,x,y,level,ierr)
!=======================================================================
! matrix-vector multiplication for row-compact matrix
! obtained from the 5-point finite difference method for
! 2D partial differential equations (PDE).
! INPUT:
!   a:  the matrix
!   x:  the vector
! OUTPUT:
!   y = a x
!----------------------------------------------------------------------
      implicit none
      integer nx,ny,level,ierr
      complex*16 a(-2:2,0:nx,0:ny),x(0:nx,0:ny),y(0:nx,0:ny)

      integer i,j,nxm1,nym1,jm1,jp1

      if (level.ge.4) then
         print'("MTX5VEC: matrix vector multiplication")'
         print*,"dim(A)=",(nx+1)*(ny+1)
      endif

      nxm1=nx-1
      nym1=ny-1

!---- interior points

      do j=1,nym1
         jm1=j-1
         jp1=j+1
      do i=1,nxm1
         y(i,j)=a(-2,i,j)*x(i,jm1)+a(-1,i,j)*x(i-1,j)+a(0,i,j)*x(i,j)
     &         +a(1,i,j)*x(i+1,j)+a(2,i,j)*x(i,jp1)
      end do
      end do

!---- four corners

      i=0
      j=0
      y(i,j)=a(0,i,j)*x(i,j)+a(1,i,j)*x(i+1,j)+a(2,i,j)*x(i,j+1)

      i=nx
      j=0
      y(i,j)=a(0,i,j)*x(i,j)+a(-1,i,j)*x(i-1,j)+a(2,i,j)*x(i,j+1)

      i=0
      j=ny
      y(i,j)=a(0,i,j)*x(i,j)+a(-2,i,j)*x(i,j-1)+a(1,i,j)*x(i+1,j)

      i=nx
      j=ny
      y(i,j)=a(0,i,j)*x(i,j)+a(-2,i,j)*x(i,j-1)+a(-1,i,j)*x(i-1,j)

!---- four sides

      i=0
      do j=1,nym1
         y(i,j)=a(-2,i,j)*x(i,j-1)+a(0,i,j)*x(i,j)
     &         +a(1,i,j)*x(i+1,j)+a(2,i,j)*x(i,j+1)
      end do

      i=nx
      do j=1,nym1
         y(i,j)=a(-2,i,j)*x(i,j-1)+a(-1,i,j)*x(i-1,j)
     &         +a(0,i,j)*x(i,j)+a(2,i,j)*x(i,j+1)
      end do

      j=0
      do i=1,nxm1
         y(i,j)=a(-1,i,j)*x(i-1,j)+a(0,i,j)*x(i,j)
     &         +a(1,i,j)*x(i+1,j)+a(2,i,j)*x(i,j+1)
      end do

      j=ny
      do i=1,nxm1
         y(i,j)=a(-2,i,j)*x(i,j-1)+a(-1,i,j)*x(i-1,j)
     &         +a(0,i,j)*x(i,j)+a(1,i,j)*x(i+1,j)
      end do

      return
      end

