!=======================================================================
      subroutine matrix9(nx,ny,nz,nbw,nvel,i3D,iorder,
     &              idnumer,iddirac,level,ierr,
     &              ax,bx,ay,by,az,bz,hx,hy,hz,omega,Qual,A,b)
!=======================================================================
      implicit none
      integer nx,ny,nz,nbw,nvel,i3D,iorder
      integer idnumer,iddirac,level,ierr
      real*8  ax,bx,ay,by,az,bz,hx,hy,hz,omega,Qual
      complex*16 A(-nbw:nbw,0:nx,0:ny),b(0:nx,0:ny)

      integer i,ix,iy,iz
      real*8  r112,r56,r23
      real*8  vel,vel0,dvel,df,hm,px,py,alpha
      real*8  r1hxsq,r1hysq,r1hzsq,r2hxsq,r2hysq,r2hzsq
      real*8  rtmp1,rtmp2,oh
      complex*16 prhs,zero,im,imQ,ctmp0,ctmp1
      complex*16 Ksq,KdK

      real*8  sxp,sxm,sym,syp

      integer id4corner
      id4corner=1

!-----------------------

      r112=1.d0/12.d0
      r56 =5.d0/6.d0
      r23 =2.d0/3.d0
      r1hxsq=1.d0/hx**2
      r1hysq=1.d0/hy**2
      r2hxsq=2.d0/hx**2
      r2hysq=2.d0/hy**2

      zero=(0.d0,0.d0)
      im=(0.d0,1.d0)
      if(Qual.gt.0.d0)then
          imQ=im/Qual
      else
          imQ=(0.d0,0.d0)
      endif

!-------------------------
! Print User Information
!-------------------------

      if(level.ge.1) then
          print'("MATRIX9: nx=",i4," ny=",i4," nz=",i4)',nx,ny,nz
          print*,"omega=",omega," Qual=",Qual," nvel=",nvel
      endif

      if(nbw.ne.4)then
          print*,"ERROR: matrix9.f: Wrong nbw=",nbw
          ierr=1
          return
      endif


!--------------------------------
! Get Contribution from -\Delta
!--------------------------------

      do iy=0,ny
      do ix=0,nx
          A(-4,ix,iy)=-r112*r1hxsq -r112*r1hysq
          A(-3,ix,iy)= r112*r2hxsq -r56 *r1hysq
          A(-2,ix,iy)=-r112*r1hxsq -r112*r1hysq
          A(-1,ix,iy)=-r56 *r1hxsq +r112*r2hysq
          A( 0,ix,iy)= r56 *r2hxsq +r56 *r2hysq
          A( 1,ix,iy)=-r56 *r1hxsq +r112*r2hysq
          A( 2,ix,iy)=-r112*r1hxsq -r112*r1hysq
          A( 3,ix,iy)= r112*r2hxsq -r56 *r1hysq
          A( 4,ix,iy)=-r112*r1hxsq -r112*r1hysq
      enddo
      enddo


!--------------------------------
! Add Contribution from K**2U
!--------------------------------

      ctmp0=((1.d0-imQ)*omega**2)*r112
      ctmp1=((1.d0-imQ)*omega**2)*r23

      do iy=0,ny
          py=ay+float(iy)*hy
      do ix=0,nx
          px=ax+float(ix)*hx
 
          A(-3,ix,iy)=A(-3,ix,iy)-ctmp0/(vel(nvel,(px),(py-hy)))**2
          A(-1,ix,iy)=A(-1,ix,iy)-ctmp0/(vel(nvel,(px-hx),(py)))**2
          A( 0,ix,iy)=A( 0,ix,iy)-ctmp1/(vel(nvel,(px),(py)))**2
          A( 1,ix,iy)=A( 1,ix,iy)-ctmp0/(vel(nvel,(px+hx),(py)))**2
          A( 3,ix,iy)=A( 3,ix,iy)-ctmp0/(vel(nvel,(px),(py+hy)))**2

      enddo
      enddo


!-----------------------------------------
! Add Contribution from the ABC
!-----------------------------------------

!--vertical edges

      hm=hx
      rtmp1=hm**2/12.d0
      rtmp2=hm**2/6.d0

      do ix=0,nx,nx
          px=ax+float(ix)*hx
          if(ix.eq.0) then
              oh=-hm
          else
              oh=hm
          endif
      do iy=0,ny
          py=ay+float(iy)*hy
          vel0=vel(nvel,px,py)
          dvel=(vel(nvel,px+oh,py)-vel(nvel,px-oh,py))/(2.d0*hm)
          if(idnumer.eq.0) then
              alpha=omega/vel0
          else
              alpha=omega
          endif
          Ksq=(1.d0-imQ)*(omega/vel0)**2
          KdK=-Ksq*(dvel/vel0)
          A(0,ix,iy)=A(0,ix,iy)
     &         +(2.d0/hm)*(im*alpha*(1.d0-rtmp1*Ksq)+rtmp2*KdK)
      enddo
      enddo

!--horizontal edges

      hm=hy
      rtmp1=hm**2/12.d0
      rtmp2=hm**2/6.d0

      do iy=0,ny,ny
          py=ay+float(iy)*hy
          if(iy.eq.0) then
              oh=-hm
          else
              oh=hm
          endif
      do ix=0,nx
          px=ax+float(ix)*hx
          vel0=vel(nvel,px,py)
          dvel=(vel(nvel,px,py+oh)-vel(nvel,px,py-oh))/(2.d0*hm)
          if(idnumer.eq.0) then
              alpha=omega/vel0
          else
              alpha=omega
          endif
          Ksq=(1.d0-imQ)*(omega/vel0)**2
          KdK=-Ksq*(dvel/vel0)
          A(0,ix,iy)=A(0,ix,iy)
     &         +(2.d0/hm)*(im*alpha*(1.d0-rtmp1*Ksq)+rtmp2*KdK)
      enddo
      enddo


!----------------
! 4-corners
!----------------

      if(id4corner.eq.1)then
      print*,"[1;7mSpecial: matrix9.f[m: 2nd-order at 4 corners"
      do iy=0,ny,ny
          py=ay+float(iy)*hy
      do ix=0,nx,nx
          px=ax+float(ix)*hx
          vel0=vel(nvel,px,py)
          if(idnumer.eq.0) then
              alpha=omega/vel0
          else
              alpha=omega
          endif
 
          A(-4,ix,iy)= zero
          A(-3,ix,iy)=-r1hysq
          A(-2,ix,iy)= zero
          A(-1,ix,iy)=-r1hxsq
          A( 0,ix,iy)= r2hxsq+r2hysq
     &                -(1.d0-imQ)*(omega/vel0)**2
     &                +im*omega*2.d0*(1.d0/hx+1.d0/hy)
          A( 1,ix,iy)=-r1hxsq
          A( 2,ix,iy)= zero
          A( 3,ix,iy)=-r1hysq
          A( 4,ix,iy)= zero
      enddo
      enddo
      endif


!--------------------------------
! Now, The Outer-Bordering
!--------------------------------

      ix=0
      do iy=0,ny
          A(-2,ix,iy)=A(-2,ix,iy)+A(-4,ix,iy)
          A( 1,ix,iy)=A( 1,ix,iy)+A(-1,ix,iy)
          A( 4,ix,iy)=A( 4,ix,iy)+A( 2,ix,iy)
          A(-4,ix,iy)=zero
          A(-1,ix,iy)=zero
          A( 2,ix,iy)=zero
      enddo

      ix=nx
      do iy=0,ny
          A(-4,ix,iy)=A(-4,ix,iy)+A(-2,ix,iy)
          A(-1,ix,iy)=A(-1,ix,iy)+A( 1,ix,iy)
          A( 2,ix,iy)=A( 2,ix,iy)+A( 4,ix,iy)
          A(-2,ix,iy)=zero
          A( 1,ix,iy)=zero
          A( 4,ix,iy)=zero
      enddo

      iy=0
      do ix=0,nx
          A( 2,ix,iy)=A( 2,ix,iy)+A(-4,ix,iy)
          A( 3,ix,iy)=A( 3,ix,iy)+A(-3,ix,iy)
          A( 4,ix,iy)=A( 4,ix,iy)+A(-2,ix,iy)
          A(-4,ix,iy)=zero
          A(-3,ix,iy)=zero
          A(-2,ix,iy)=zero
      enddo

      iy=ny
      do ix=0,nx
          A(-4,ix,iy)=A(-4,ix,iy)+A( 2,ix,iy)
          A(-3,ix,iy)=A(-3,ix,iy)+A( 3,ix,iy)
          A(-2,ix,iy)=A(-2,ix,iy)+A( 4,ix,iy)
          A( 2,ix,iy)=zero
          A( 3,ix,iy)=zero
          A( 4,ix,iy)=zero
      enddo


!================================
! Right Hand Side "b"
!================================

      if(iddirac.eq.1) goto 2000

      sym=hy
      syp=hy
      do iy=0,ny
          py=ay+float(iy)*hy
          if(iy.eq.1)  sym=-hy
          if(iy.eq.ny) syp=-hy
          sxm=hx
          sxp=hx
      do ix=0,nx
          if(ix.eq.1)  sxm=-hx
          if(ix.eq.nx) sxp=-hx
          px=ax+float(ix)*hx
          b(ix,iy)=r23 * prhs(nvel,omega,imQ,(px),(py))
     &            +r112*(prhs(nvel,omega,imQ,(px+sxm),(py))
     &                  +prhs(nvel,omega,imQ,(px+sxp),(py))
     &                  +prhs(nvel,omega,imQ,(px),(py+sym))
     &                  +prhs(nvel,omega,imQ,(px),(py+syp)) )
      enddo
      enddo

!-----------------------------
! the ABC-Contribution to "b"
!-----------------------------

!--vertical edges

      hm=hx
      do ix=0,nx,nx
          px=ax+float(ix)*hx
          if(ix.eq.0) then
              oh=-hm
          else
              oh=hm
          endif
      do iy=0,ny
          py=ay+float(iy)*hy
          df=(prhs(nvel,omega,imQ,px+oh,py)
     &       -prhs(nvel,omega,imQ,px-oh,py))/(2.d0*hm)
          b(ix,iy)=b(ix,iy)-(hm/3.d0)*df
      enddo
      enddo

!--horizontal edges

      hm=hy
      do iy=0,ny,ny
          py=ay+float(iy)*hy
          if(iy.eq.0) then
              oh=-hm
          else
              oh=hm
          endif
      do ix=0,nx
          px=ax+float(ix)*hx
          df=(prhs(nvel,omega,imQ,px,py+oh)
     &       -prhs(nvel,omega,imQ,px,py-oh))/(2.d0*hm)
          b(ix,iy)=b(ix,iy)-(hm/3.d0)*df
      enddo
      enddo

!----------------
! 4-corners
!----------------
      if(id4corner.eq.1)then
      do iy=0,ny,ny
          py=ay+float(iy)*hy
      do ix=0,nx,nx
          px=ax+float(ix)*hx
          b(ix,iy)=prhs(nvel,omega,imQ,px,py)
      enddo
      enddo
      endif


 2000 continue

!===================================
!      When iddirac=1
!===================================
      if(iddirac.eq.1)then
          do iy=0,ny
          do ix=0,nx
              b(ix,iy)=(0.d0,0.d0)
          enddo
          enddo
          b(nx/4,ny/4)=1000.d0
      endif

!===================================
!      When omega=0.d0
!===================================
      if(omega.le.1.d-6)then
          A(-4,0,0)=0.d0
          A(-3,0,0)=0.d0
          A(-2,0,0)=0.d0
          A(-1,0,0)=0.d0
          A( 0,0,0)=r1hxsq
          A( 1,0,0)=0.d0
          A( 2,0,0)=0.d0
          A( 3,0,0)=0.d0
          A( 4,0,0)=0.d0
          b(0,0)=0.d0
      endif

      return
      end

