!=======================================================================
      subroutine matrix5(nx,ny,nz,nbw,nvel,i3D,iorder,
     &              idnumer,iddirac,level,ierr,
     &              ax,bx,ay,by,az,bz,hx,hy,hz,omega,Qual,A,b)
!=======================================================================
      implicit none
      integer nx,ny,nz,nbw,nvel,i3D,iorder
      integer idnumer,iddirac,level,ierr
      real*8  ax,bx,ay,by,az,bz,hx,hy,hz,omega,Qual
      complex*16 A(-nbw:nbw,0:nx,0:ny),b(0:nx,0:ny)

      integer i,ix,iy,iz
      real*8  vel,vel0,dvel,df,hm,px,py,alpha
      real*8  r1hxsq,r1hysq,r1hzsq,r2hxsq,r2hysq,r2hzsq
      real*8  rtmp1,rtmp2,oh
      complex*16 prhs,zero,im,imQ,ctmp0,ctmp1
      complex*16 Ksq,KdK

!-----------------------

      r1hxsq=1.d0/hx**2
      r1hysq=1.d0/hy**2
      r2hxsq=2.d0/hx**2
      r2hysq=2.d0/hy**2

      zero=(0.d0,0.d0)
      im=(0.d0,1.d0)
      if(Qual.gt.0.d0)then
          imQ=im/Qual
      else
          imQ=(0.d0,0.d0)
      endif

!-------------------------
! Print User Information
!-------------------------

      if(level.ge.1) then
          print'("MATRIX5: nx=",i4," ny=",i4," nz=",i4)',nx,ny,nz
          print*,"omega=",omega," Qual=",Qual," nvel=",nvel
      endif

      if(nbw.ne.4)then
          print*,"ERROR: matrix5.f: Wrong nbw=",nbw
          ierr=1
          return
      endif


!--------------------------------
! Get Contribution from -\Delta
!--------------------------------

      do iy=0,ny
      do ix=0,nx
          A(-4,ix,iy)= zero
          A(-3,ix,iy)=-r1hysq
          A(-2,ix,iy)= zero
          A(-1,ix,iy)=-r1hxsq
          A( 0,ix,iy)= r2hxsq+r2hysq
          A( 1,ix,iy)=-r1hxsq
          A( 2,ix,iy)= zero
          A( 3,ix,iy)=-r1hysq
          A( 4,ix,iy)= zero
      enddo
      enddo


!--------------------------------
! Add Contribution from K**2U
!--------------------------------

      ctmp1=(1.d0-imQ)*omega**2
      do iy=0,ny
          py=ay+float(iy)*hy
      do ix=0,nx
          px=ax+float(ix)*hx
          A(0,ix,iy)=A(0,ix,iy)-ctmp1/(vel(nvel,(px),(py)))**2
      enddo
      enddo


!-----------------------------------------
! Add Contribution from the ABC
!-----------------------------------------

!--vertical edges

      hm=hx
      do ix=0,nx,nx
          px=ax+float(ix)*hx
      do iy=0,ny
          py=ay+float(iy)*hy
          if(idnumer.eq.0) then
              alpha=omega/vel(nvel,px,py)
          else
              alpha=omega
          endif
          A(0,ix,iy)=A(0,ix,iy)+(2.d0/hm)*im*alpha
      enddo
      enddo

!--horizontal edges

      hm=hy
      do iy=0,ny,ny
          py=ay+float(iy)*hy
      do ix=0,nx
          px=ax+float(ix)*hx
          if(idnumer.eq.0) then
              alpha=omega/vel(nvel,px,py)
          else
              alpha=omega
          endif
          A(0,ix,iy)=A(0,ix,iy)+(2.d0/hm)*im*alpha
      enddo
      enddo


!--------------------------------
! Now, The Outer-Bordering
!--------------------------------

      ix=0
      do iy=0,ny
          A(-2,ix,iy)=A(-2,ix,iy)+A(-4,ix,iy)
          A( 1,ix,iy)=A( 1,ix,iy)+A(-1,ix,iy)
          A( 4,ix,iy)=A( 4,ix,iy)+A( 2,ix,iy)
          A(-4,ix,iy)=zero
          A(-1,ix,iy)=zero
          A( 2,ix,iy)=zero
      enddo

      ix=nx
      do iy=0,ny
          A(-4,ix,iy)=A(-4,ix,iy)+A(-2,ix,iy)
          A(-1,ix,iy)=A(-1,ix,iy)+A( 1,ix,iy)
          A( 2,ix,iy)=A( 2,ix,iy)+A( 4,ix,iy)
          A(-2,ix,iy)=zero
          A( 1,ix,iy)=zero
          A( 4,ix,iy)=zero
      enddo

      iy=0
      do ix=0,nx
          A( 2,ix,iy)=A( 2,ix,iy)+A(-4,ix,iy)
          A( 3,ix,iy)=A( 3,ix,iy)+A(-3,ix,iy)
          A( 4,ix,iy)=A( 4,ix,iy)+A(-2,ix,iy)
          A(-4,ix,iy)=zero
          A(-3,ix,iy)=zero
          A(-2,ix,iy)=zero
      enddo

      iy=ny
      do ix=0,nx
          A(-4,ix,iy)=A(-4,ix,iy)+A( 2,ix,iy)
          A(-3,ix,iy)=A(-3,ix,iy)+A( 3,ix,iy)
          A(-2,ix,iy)=A(-2,ix,iy)+A( 4,ix,iy)
          A( 2,ix,iy)=zero
          A( 3,ix,iy)=zero
          A( 4,ix,iy)=zero
      enddo


!================================
! Right Hand Side "b"
!================================

      if(iddirac.eq.1)then
          do iy=0,ny
          do ix=0,nx
              b(ix,iy)=(0.d0,0.d0)
          enddo
          enddo
          b(nx/4,ny/4)=1000.d0
      else
          do iy=0,ny
              py=ay+float(iy)*hy
          do ix=0,nx
              px=ax+float(ix)*hx
              b(ix,iy)=prhs(nvel,omega,imQ,(px),(py))
          enddo
          enddo
      endif

!===================================
!      When omega=0.d0
!===================================
      if(omega.le.1.d-6)then
          A(-4,0,0)=0.d0
          A(-3,0,0)=0.d0
          A(-2,0,0)=0.d0
          A(-1,0,0)=0.d0
          A( 0,0,0)=r1hxsq
          A( 1,0,0)=0.d0
          A( 2,0,0)=0.d0
          A( 3,0,0)=0.d0
          A( 4,0,0)=0.d0
          b(0,0)=0.d0
      endif

      return
      end

