!=======================================================================
      real*8 function vel(nvel,x,y)
!=======================================================================
      implicit none
      integer nvel
      real*8  x,y
      real*8  pi

      if(nvel.eq.1)then
          vel = 2.d0
      elseif(nvel.eq.2)then
          pi=4.d0*datan(1.d0)
          vel=1.6d0+abs(dsin(3.d0*pi*x)*dcos(4.d0*pi*y))
      elseif(nvel.eq.3)then
          if(x.lt.0.500001d0) then
              vel=2.d0
          else
              pi=4.d0*datan(1.d0)
              vel=2.d0+dsin(5.d0*pi*x*y)
          endif
      else
          vel = 2.d0
      endif

      return
      end

!=======================================================================
      complex*16 function true(omega,x,y)
!=======================================================================
      implicit none
      real*8 omega,x,y
      complex*16 phi
      true = phi(omega,x)*phi(omega,y)
      return
      end

!=======================================================================
      complex*16 function phi(omega,x)
!=======================================================================
      implicit none
      real*8 omega,x
      complex*16 tm1,tm2
 
      tm1= omega*(x-1.d0)*(0.d0,1.d0)
      tm2=-omega*  x   *(0.d0,1.d0)
      phi= cdexp(tm1)+cdexp(tm2)-2.d0
      return
      end

!=======================================================================
      complex*16 function prhs(nvel,omega,imQ,x,y)
!=======================================================================
      implicit none
      integer nvel
      real*8 omega,x,y
      complex*16 imQ
      real*8 vel,vel0
      complex*16 phi,phix,phiy,u

      phix=phi(omega,x)
      phiy=phi(omega,y)
      u=phix*phiy
      vel0=vel(nvel,x,y)
      prhs=2.d0*omega**2*(u+phix+phiy)
     &    -((1.d0-imQ)*(omega/vel0)**2)*u
 
      return
      end

