!=======================================================================
      subroutine HelmCGNR(nx,ny,nz,iorder,nvel,iddirac,idnumer,itmax,
     &       i3D,nwrow,neqn,level,ierr,
     &       ax,bx,ay,by,az,bz,freq,Qual,tol,
     &       A,AT,ILU,ILUT,x,b,wksp)
!=======================================================================
      implicit none
      integer nx,ny,nz,iorder,nvel,iddirac,idnumer,itmax
      integer i3D,nwrow,neqn,level,ierr
      real*8  ax,bx,ay,by,az,bz,freq,Qual,tol
      complex*16 A(nwrow,neqn),AT(nwrow,neqn)
      complex*16 ILU(nwrow,neqn),ILUT(nwrow,neqn)
      complex*16 x(neqn),b(neqn),wksp(neqn,4)

!---- local variables

      integer i,ix,iy,iz
      integer nbw,itCGNR
      real*8  hx,hy,hz
      real*8  pi,omega
      real    utime0,stime0,utime1,stime1

!-------------------------
! Initial setting
!-------------------------

      nbw=nwrow/2
      hx=(bx-ax)/float(nx)
      hy=(by-ay)/float(ny)
      if(i3D.eq.1) hz=(bz-az)/float(nz)

      pi=4.d0*datan(1.d0)
      omega=2.d0*pi*freq
      if(iddirac.eq.1) then
          if(idnumer.ne.0)then
          idnumer=0
          if(level.gt.0)print*,"[1;7mCHANGE[m: idnumer=",idnumer
          endif
      endif

!-------------------------
! Print User Information
!-------------------------

      if(level.ge.1) then
          print'("HelmCGNR: nx=",i4," ny=",i4," nz=",i4)',nx,ny,nz
          print*,"iorder=",iorder," nvel=",nvel," iddirac=",iddirac
          print*,"itmax=",itmax," idnumer=",idnumer," i3D=",i3D
          print*,"freq=",freq," Qual=",Qual," tol=",tol
      endif

      if(i3D.eq.1) then
          print*,"HelmCGNR.f: not yet for i3D=",i3D," iorder=",iorder
          ierr=1
          return
      endif

      if(level.gt.0) call etimef77(utime0,stime0)

!--------------------------------
! Get the Matrix "A" and RHS "b"
!--------------------------------

      if(iorder.eq.2) then

          call matrix5(nx,ny,nz,nbw,nvel,i3D,iorder,
     &            idnumer,iddirac,level,ierr,
     &            ax,bx,ay,by,az,bz,hx,hy,hz,omega,Qual,A,b)

      else if(iorder.eq.4) then

          call matrix9(nx,ny,nz,nbw,nvel,i3D,iorder,
     &            idnumer,iddirac,level,ierr,
     &            ax,bx,ay,by,az,bz,hx,hy,hz,omega,Qual,A,b)

      endif


!--------------------------------
! Call PCGNR-ILU0
!--------------------------------

      if(omega.ge.1.d-6)then
          do i=1,neqn
              x(i)=(0.d0,0.d0)  !initialization
          enddo
      else
          do i=1,neqn
              x(i)=(1.d0,0.d0)  !initialization
          enddo
      endif

      call cgnr9(nx,ny,nbw,itmax,itCGNR,level,ierr,tol,
     &           A,AT,ILU,ILUT,x,b,wksp)


!--------------------------------
! Numerical Checking
!--------------------------------
      if(level.le.0)return

      call etimef77(utime1,stime1)

      print'("HelmCGNR: nx=",i4," ny=",i4," nz=",i4)',nx,ny,nz
      print*,"iorder=",iorder," nvel=",nvel," iddirac=",iddirac
      print*,"itmax=",itmax," idnumer=",idnumer," i3D=",i3D
      print*,"freq=",freq," Qual=",Qual," tol=",tol
      print'("PCGNR Iteration=",i5)',itCGNR
      print'("Elapsed Time   =",f7.2)',utime1-utime0

!------------

      if(idnumer.ge.1)then
          call numerical(nx,ny,nz,nbw,idnumer,iddirac,level,ierr,
     &            omega,ax,bx,ay,by,az,bz,hx,hy,hz,A,x,b,wksp)
      endif

!------------

      open(1,file="fort.1")
         write(1,*) nx+1,ax,bx,hx,ny+1,ay,by,hy
      close(1)
      open(2,file="fort.2")
         write(2,*) freq,max(0.,Qual)
      close(2)

      open(68,file="fort.Ureal")
      print*,"<fort.Ureal> contains real(Xm)"
          do i=1,neqn
              write(68,*) dreal(x(i))
          enddo
      close(68)
      open(69,file="fort.Uimag")
      print*,"<fort.Uimag> contains imag(Xm)"
          do i=1,neqn
              write(69,*) dimag(x(i))
          enddo
      close(69)

      return
      end

