!=======================================================================
      subroutine sol_Explicit(nt,nx,ny,idsol,nb,nwA,nBC,level,ierr,
     &      at,bt,ax,bx,ay,by,theta,constDiff,omega,
     &      mnxy,idnumer,isrcx,isrcy,iObsx,iObsy,id2,ipOut,
     &      src_IN,src_Ex,src_Ey,src_CO,Obser,
     &      ht,hx,hy,scheme, A1,A2,H,V,U,D,S,F,vel,BCcos,ws2,wksp)
!=======================================================================
      implicit none
      integer nt,nx,ny,idsol,nb,nwA,nBC,level,ierr
      real*8  at,bt,ax,bx,ay,by,theta,constDiff,omega
      integer mnxy,idnumer,isrcx,isrcy,iObsx,iObsy,id2,ipOut
      logical src_IN,src_Ex,src_Ey,src_CO,Obser
      real*8  ht,hx,hy
      real*8  A1(-nb:nb,0:nx,0:ny),A2(-nb:nb,0:ny,0:nx)
      real*8  H(-nb:nb,0:nx,0:ny),V(-nb:nb,0:ny,0:nx)
      real*8  U(0:nx,0:ny,0:2),D(*),F(0:nt),vel(0:nx,0:ny)
      real*8  S(0:nx,0:ny)
      real*8  BCcos(0:mnxy,4),ws2(0:ny,0:nx),wksp(0:nx,0:ny)
      character*40 scheme

!------------------------------------
!---- local variables
!------------------------------------

      integer i,j,k,n,id0,id1,ipjump
      integer nxm1,nym1,level0
      real*8  time,htsq,theta_htsq,eps0,AUtilde

!------------------------------------
!---- print out and basic setting
!------------------------------------

      if(level.ge.1)then
         print'("SOL_Explicit: idsol=",i2,": ",a40)',idsol,scheme
      endif

      if(level.ge.3)then
         print*,"nx=",nx," ax=",ax," bx=",bx," hx=",hx
         print*,"ny=",ny," ay=",ay," by=",by," hy=",hy
         print*,"nt=",nt," at=",at," bt=",bt," ht=",ht
         print*,"constDiff=",constDiff," theta=",theta
      endif

      nxm1=nx-1
      nym1=ny-1
      level0=0

      eps0=1.d-6
      htsq=ht*ht
      theta_htsq=theta*htsq

      id0=0
      id1=1
      ipjump=max(1,((nt/10+49)/50)*50)

!====================================
!---- Time marching
!====================================
      do n=2,nt
!====================================

      id2=mod(n,3)
      time=at+dble(n-1)*ht
      if(n.eq.2 .or. mod(n,ipjump).eq.0 .or. n.eq.nt) then
          if(level.ge.2) print*,"n=",n," t=",(time+ht)
      endif

!-------------------
!-- Explicit step
!-------------------

      if(idnumer.eq.1)then
          call getS(n,nx,ny,nb,level0,ierr,time,ht,theta,
     &              ax,bx,ay,by,vel,omega,S)
      endif

      !---- Compute "u-tilde"

      do j=0,ny
      do i=0,nx
          wksp(i,j)=2.d0*U(i,j,id1)-U(i,j,id0)
      enddo
      enddo

      call explicit(n,nt,nx,ny,nb,isrcx,isrcy,idnumer,level0,ierr,
     &       mnxy,theta,ht,hx,hy,time, src_IN,src_Ex,src_Ey,src_CO,
     &       vel,S,F,A1,A2,U(0,0,id2),U(0,0,id1),U(0,0,id0),
     &       BCcos,wksp,ws2)

      if(Obser.and.level.ge.1)then
         write(ipOut,*) (time+ht),U(iObsx,iObsy,id2)
      endif

      id0=id1
      id1=id2

!====================================
      enddo
!====================================

      return
      end
