!=======================================================================
      subroutine readU0G(nx,ny,nInit,level,ierr, ax,bx,ay,by,
     &                   c0,omega,idnumer,U,G)
!=======================================================================
      implicit none
      integer nx,ny,nInit,level,idnumer,ierr
      real*8  ax,bx,ay,by,c0,omega
      real*8  U(0:nx,0:ny),G(0:nx,0:ny)

      integer ix,iy
      real*8  hx,hy,pi,px,py
      real*8  zero,trueu,trueut

!---- Interface

      if(level.ge.1)print'("READ_U0G: nInit=",i2)',nInit
      if(level.ge.2) then
          print*,"nx=",nx," ax=",ax," bx=",bx
          print*,"ny=",ny," ay=",ay," by=",by
          print*,"c0=",c0," omega=",omega
      endif

!-----------------------

      hx=(bx-ax)/dble(nx)
      hy=(by-ay)/dble(ny)
      pi=4.d0*datan(1.d0)
      zero=0.d0

      if(idnumer.eq.1) goto 1000

!-------------------------
! read "U0" and "G=Ut(0)"
!-------------------------

      if(nInit.eq.0)then

          do iy=0,ny
          do ix=0,nx
             U(ix,iy)=0.d0
          enddo
          enddo

          do iy=0,ny
          do ix=0,nx
             G(ix,iy)=0.d0
          enddo
          enddo

      else if(nInit.eq.1)then

          do iy=0,ny
          do ix=0,nx
             U(ix,iy)=0.d0
          enddo
          enddo

          do iy=0,ny
          do ix=0,nx
             G(ix,iy)=1.d-6
          enddo
          enddo

      else if(nInit.eq.11)then   ! viscoelastic

          do iy=0,ny
             py=ay+hy*dble(iy)
          do ix=0,nx
             px=ax+hx*dble(ix)
             U(ix,iy)=dsin(2.d0*pi*px*(px+1.d0))
     &               *(4.*(py-0.5d0)**2-0.5d0)
*     &               *dsin(2.d0*pi*py*(py+1.d0))
          enddo
          enddo

          !--- Zero Dirichlet BC
          do iy=0,ny,ny
          do ix=0,nx
             U(ix,iy)=0.d0
          enddo
          enddo
          do iy=0,ny
          do ix=0,nx,nx
             U(ix,iy)=0.d0
          enddo
          enddo

          !--- set G

          do iy=0,ny
          do ix=0,nx
             G(ix,iy)=0.d0
          enddo
          enddo

      else

          print*,"Error: readU0G.f: Be careful on nInit!!"
          ierr=1
          return

      endif

      RETURN

 1000 continue

      do iy=0,ny
         py=ay+hy*dble(iy)
      do ix=0,nx
         px=ax+hx*dble(ix)
         U(ix,iy)=trueu(zero,px,py,bx,c0,omega)
         G(ix,iy)=trueut(zero,px,py,bx,c0,omega)
      enddo
      enddo



      RETURN
      END

