!=======================================================================
      subroutine getU1(nx,ny,nt,nb,nBC,isrcx,isrcy,idnumer,level,ierr,
     &           ax,bx,ay,by,c0,omega,theta, at,ht,hx,hy,
     &           src_IN,src_Ex,src_Ey,src_CO,
     &           vel,F,S,G,A1,A2,U,wksp,AU0)
!=======================================================================
      implicit none
      integer nx,ny,nt,nb,nBC,isrcx,isrcy,idnumer,level,ierr
      real*8  ax,bx,ay,by,c0,omega,theta, at,ht,hx,hy
      logical src_IN,src_Ex,src_Ey,src_CO
      real*8  A1(-nb:nb,0:nx,0:ny),A2(-nb:nb,0:ny,0:nx)
      real*8  F(0:nt),S(0:nx,0:ny),G(0:nx,0:ny),vel(0:nx,0:ny)
      real*8  U(0:nx,0:ny,0:2),wksp(0:nx,0:ny,*),AU0(0:nx,0:ny)

!---------------------
!---- local variables
!---------------------

      integer ix,iy,nxm1,nym1,id
      real*8  half_htsq,thirdDt,twel_htsq,fac0,fac1,fac2
      real*8  a_out,a_out2,coef,vel0

      nxm1=nx-1
      nym1=ny-1
      half_htsq=0.5d0*ht**2

      thirdDt=ht/3.d0
      fac0= 7.d0/12.d0
      fac1= 6.d0/12.d0
      fac2=-1.d0/12.d0
      twel_htsq=ht**2/12.d0

!---- Interface

      if(level.ge.1)then
          print'("GET_U1:",$)'
          print*,"nBC=",nBC," isrcx=",isrcx," isrcy=",isrcy
      endif

      call getAU(nx,ny,nb,level,ierr,A1,A2,U(0,0,0),AU0)


!============================
!---- Interior points, first
!============================

!------------------------------
      if(nb.eq.1) then
!------------------------------

          if(idnumer.ge.1)then
              do iy=1,nym1
              do ix=1,nxm1
                  U(ix,iy,1)=U(ix,iy,0)+ht*G(ix,iy)
     &               +half_htsq*(vel(ix,iy))**2*(S(ix,iy)-AU0(ix,iy))
              enddo
              enddo
          else
              do iy=1,nym1
              do ix=1,nxm1
                  U(ix,iy,1)=U(ix,iy,0)+ht*G(ix,iy)
     &               +half_htsq*(vel(ix,iy))**2*(-AU0(ix,iy))
              enddo
              enddo
          endif

          if(src_IN) then
              U(isrcx,isrcy,1)=U(isrcx,isrcy,1)
     &                        +half_htsq*(vel(isrcx,isrcy))**2*F(0)
          endif

!------------------------------
      else if(nb.eq.2) then
!------------------------------

          if(idnumer.ge.1)then

              do iy=0,ny
              do ix=0,nx
                  wksp(ix,iy,1)=U(ix,iy,0)+thirdDt*G(ix,iy)
     &               +twel_htsq*(vel(ix,iy))**2*(S(ix,iy)-AU0(ix,iy))
              enddo
              enddo
              call getAU(nx,ny,nb,level,ierr,A1,A2,
     &                   wksp(0,0,1),wksp(0,0,3))

              call getS(0,nx,ny,nb,level,ierr,(at+ht),ht,theta,
     &                  ax,bx,ay,by,c0,omega,wksp(0,0,1))
              call getS(0,nx,ny,nb,level,ierr,(at+2.d0*ht),ht,theta,
     &                  ax,bx,ay,by,c0,omega,wksp(0,0,2))

              do iy=1,nym1
              do ix=1,nxm1
                  U(ix,iy,1)=U(ix,iy,0)+ht*G(ix,iy)
     &               +half_htsq*(vel(ix,iy))**2*(fac0*S(ix,iy)
     &                       +fac1*wksp(ix,iy,1)+fac2*wksp(ix,iy,2)
     &                       -wksp(ix,iy,3))
              enddo
              enddo

          else

              do iy=0,ny
              do ix=0,nx
                  wksp(ix,iy,1)=U(ix,iy,0)+thirdDt*G(ix,iy)
     &               +twel_htsq*(vel(ix,iy))**2*(-AU0(ix,iy))
              enddo
              enddo
              call getAU(nx,ny,nb,level,ierr,A1,A2,
     &                   wksp(0,0,1),wksp(0,0,3))

              do iy=1,nym1
              do ix=1,nxm1
                  U(ix,iy,1)=U(ix,iy,0)+ht*G(ix,iy)
     &               +half_htsq*(vel(ix,iy))**2*(-wksp(ix,iy,3))
              enddo
              enddo

          endif

          if(src_IN) then
              U(isrcx,isrcy,1)=U(isrcx,isrcy,1)
     &            +half_htsq*(vel(isrcx,isrcy))**2
     &                  *(fac0*F(0)+fac1*F(1)+fac2*F(2))
          endif

!------------------------------
      endif
!------------------------------


!==========================================
!---- Now, Boundary points
!==========================================

!---------------------------
      if(idnumer.ge.1)then
!---------------------------

      !---- Edge points

          id=-1
          do ix=0,nx,nx
          do iy=1,nym1
              a_out=A1(id,ix,iy)
              vel0 =vel(ix,iy)
              coef =1.d0-a_out*hx*ht*vel0
              U(ix,iy,1)=( coef*U(ix,iy,0)+ht*G(ix,iy)
     &            +half_htsq*vel0**2*(S(ix,iy)-AU0(ix,iy)) )/coef
          enddo
          id=1
          enddo

          id=-1
          do iy=0,ny,ny
          do ix=1,nxm1
              a_out=A2(id,iy,ix)
              vel0 =vel(ix,iy)
              coef =1.d0-a_out*hy*ht*vel0
              U(ix,iy,1)=( coef*U(ix,iy,0)+ht*G(ix,iy)
     &            +half_htsq*vel0**2*(S(ix,iy)-AU0(ix,iy)) )/coef
          enddo
          id=1
          enddo

          !---- Corner points

          do iy=0,ny,ny
          do ix=0,nx,nx
              a_out =A1(1,ix,iy)
              a_out2=A2(1,iy,ix)
              vel0  =vel(ix,iy)
              coef =1.d0-a_out *hx*ht*vel0
     &                  -a_out2*hy*ht*vel0
              U(ix,iy,1)=( coef*U(ix,iy,0)+ht*G(ix,iy)
     &            +half_htsq*vel0**2*(S(ix,iy)-AU0(ix,iy)) )/coef
          enddo
          enddo

!---------------------------
      else
!---------------------------

      !---- Edge points

          id=-1
          do ix=0,nx,nx
          do iy=1,nym1
              a_out=A1(id,ix,iy)
              vel0 =vel(ix,iy)
              coef =1.d0-a_out*hx*ht*vel0
              U(ix,iy,1)=( coef*U(ix,iy,0)+ht*G(ix,iy)
     &            +half_htsq*vel0**2*(-AU0(ix,iy)) )/coef
          enddo
          id=1
          enddo

          id=-1
          do iy=0,ny,ny
          do ix=1,nxm1
              a_out=A2(id,iy,ix)
              vel0 =vel(ix,iy)
              coef =1.d0-a_out*hy*ht*vel0
              U(ix,iy,1)=( coef*U(ix,iy,0)+ht*G(ix,iy)
     &            +half_htsq*vel0**2*(-AU0(ix,iy)) )/coef
          enddo
          id=1
          enddo

          !---- Corner points

          do iy=0,ny,ny
          do ix=0,nx,nx
              a_out =A1(1,ix,iy)
              a_out2=A2(1,iy,ix)
              vel0  =vel(ix,iy)
              coef =1.d0-a_out *hx*ht*vel0
     &                  -a_out2*hy*ht*vel0
              U(ix,iy,1)=( coef*U(ix,iy,0)+ht*G(ix,iy)
     &            +half_htsq*vel0**2*(-AU0(ix,iy)) )/coef
          enddo
          enddo

!---------------------------
      endif
!---------------------------

!---- At the source point

      if(src_Ex .or. src_Ey .or. src_CO) then
          ix=isrcx
          iy=isrcy

          if(src_Ex) then
              a_out=A1(1,ix,iy)
              vel0 =vel(ix,iy)
              coef =1.d0-a_out*hx*ht*vel0
          else if(src_Ey) then
              a_out=A2(1,iy,ix)
              vel0 =vel(ix,iy)
              coef =1.d0-a_out*hy*ht*vel0
          else if(src_CO) then
              a_out =A1(1,ix,iy)
              a_out2=A2(1,iy,ix)
              vel0  =vel(ix,iy)
              coef =1.d0-a_out *hx*ht*vel0
     &                  -a_out2*hy*ht*vel0
          endif

          U(ix,iy,1)=( coef*U(ix,iy,0)+ht*G(ix,iy)
     &        +half_htsq*vel0**2*(F(0)-AU0(ix,iy)) )/coef

      endif


      return
      end

