!=======================================================================
      subroutine getS(n,nx,ny,nb,level,ierr,t0,ht,theta,
     &                ax,bx,ay,by,c0,omega,S)
!=======================================================================
      implicit none
      integer n,nx,ny,nb,level,ierr
      real*8  t0,ht,theta,ax,bx,ay,by,c0,omega
      real*8  S(0:nx,0:ny)

      integer ix,iy
      real*8  hx,hy,px,py,fac0,rhs

!---- Interface

      if(level.ge.1)print'("GET_S:")'
      if(level.ge.2) then
         print*,"nx=",nx," ax=",ax," bx=",bx
         print*,"ny=",ny," ay=",ay," by=",by
      endif


      hx=(bx-ax)/dble(nx)
      hy=(by-ay)/dble(ny)

!--------------------------------------
      if(n.eq.0)then
!--------------------------------------

          do iy=0,ny
              py=ay+hy*dble(iy)
          do ix=0,nx
              px=ax+hx*dble(ix)
              S(ix,iy)=rhs(t0,px,py,bx,c0,omega)
          enddo
          enddo

!--------------------------------------
      else
!--------------------------------------

          if(theta.lt.(1.d-8))then

              do iy=0,ny
                  py=ay+hy*dble(iy)
              do ix=0,nx
                  px=ax+hx*dble(ix)
                  S(ix,iy)=rhs(t0,px,py,bx,c0,omega)
              enddo
              enddo

          else

              fac0=1.d0-2.d0*theta

              do iy=0,ny
                  py=ay+hy*dble(iy)
              do ix=0,nx
                  px=ax+hx*dble(ix)
                  S(ix,iy)=fac0 *rhs(t0,px,py,bx,c0,omega)
     &                    +theta*(rhs(t0-ht,px,py,bx,c0,omega)
     &                           +rhs(t0+ht,px,py,bx,c0,omega))
              enddo
              enddo

          endif

!--------------------------------------
      endif
!--------------------------------------

      RETURN
      END

