!=======================================================================
      subroutine explicit(n,nt,nx,ny,nb,isrcx,isrcy,idnumer,level,ierr,
     &      mnxy,theta,ht,hx,hy,time, src_IN,src_Ex,src_Ey,src_CO,
     &      vel,S,F,A1,A2,U2,U1,U0,BCcos,Utilde,AU1)
!=======================================================================
      implicit none
      integer n,nt,nx,ny,nb,isrcx,isrcy,idnumer,level,ierr,mnxy
      real*8  theta,ht,hx,hy,time
      logical src_IN,src_Ex,src_Ey,src_CO
      real*8  A1(-nb:nb,0:nx,0:ny),A2(-nb:nb,0:ny,0:nx)
      real*8  S(0:nx,0:ny),F(0:nt),vel(0:nx,0:ny)
      real*8  U2(0:nx,0:ny),U1(0:nx,0:ny),U0(0:nx,0:ny),BCcos(0:mnxy,4)
      real*8  Utilde(0:nx,0:ny),AU1(0:nx,0:ny)

!---------------------
!---- local variables
!---------------------

      integer ix,iy,i,k,nxm1,nym1,id0
      real*8  htsq,tmpF,coef,vel0
      real*8  dx,dy

      nxm1=nx-1
      nym1=ny-1
      htsq=ht**2

!---- Interface

      if(level.ge.1)then
          print'("EXPLICIT:",$)'
          print*,"n=",n
      endif

!============================
!---- Interior points, first
!============================

      call getAU(nx,ny,nb,level,ierr,A1,A2,U1,AU1)

      do iy=1,nym1
      do ix=1,nxm1
          U2(ix,iy)=Utilde(ix,iy)-htsq*(vel(ix,iy))**2*AU1(ix,iy)
      enddo
      enddo

      if(src_IN) then
          ix=isrcx
          iy=isrcy
          U2(ix,iy)=U2(ix,iy)+htsq*(vel(ix,iy))**2
     &          *((1.d0-2.d0*theta)*F(n-1)+theta*(F(n-2)+F(n)))
      endif

      if(idnumer.ge.1) then
          do iy=1,nym1
          do ix=1,nxm1
              U2(ix,iy)=U2(ix,iy)+htsq*(vel(ix,iy))**2*S(ix,iy)
          enddo
          enddo
      endif


!============================
!---- Now, Boundary points
!============================

!--- cos(alpha)

      if(n.eq.2) then
      if(idnumer.ge.1)then
          do k=1,4
          do i=0,mnxy
              BCcos(i,k)=1.d0
          enddo
          enddo
      else
          id0=1
          do ix=0,nx,nx
          do iy=1,nym1
              dx=hx*(ix-isrcx)
              dy=hy*(iy-isrcy)
              BCcos(iy,id0)=dabs(dx)/dsqrt(dx**2+dy**2)
          enddo
          id0=2
          enddo

          id0=3
          do iy=0,ny,ny
          do ix=1,nxm1
              dx=hx*(ix-isrcx)
              dy=hy*(iy-isrcy)
              BCcos(ix,id0)=dabs(dy)/dsqrt(dx**2+dy**2)
          enddo
          id0=4
          enddo

      endif
      endif


!---------------------------
      if(idnumer.ge.1)then
!---------------------------

      !---- Edge points

          id0=1
          do ix=0,nx,nx
          do iy=1,nym1
              vel0=vel(ix,iy)
              coef=A1(1,ix,iy)*hx*ht*vel0 *BCcos(iy,id0)
              U2(ix,iy)=( Utilde(ix,iy)-coef*U0(ix,iy)
     &            +htsq*vel0**2*(S(ix,iy)-AU1(ix,iy)) )/(1.d0-coef)
          enddo
          id0=2
          enddo

          id0=3
          do iy=0,ny,ny
          do ix=1,nxm1
              vel0=vel(ix,iy)
              coef=A2(1,iy,ix)*hy*ht*vel0 *BCcos(ix,id0)
              U2(ix,iy)=( Utilde(ix,iy)-coef*U0(ix,iy)
     &            +htsq*vel0**2*(S(ix,iy)-AU1(ix,iy)) )/(1.d0-coef)
          enddo
          id0=4
          enddo

          !---- Corner points

          do iy=0,ny,ny
          do ix=0,nx,nx
              vel0=vel(ix,iy)
              coef=A1(1,ix,iy)*hx*ht*vel0
     &            +A2(1,iy,ix)*hy*ht*vel0
              U2(ix,iy)=( Utilde(ix,iy)-coef*U0(ix,iy)
     &            +htsq*vel0**2*(S(ix,iy)-AU1(ix,iy)) )/(1.d0-coef)
          enddo
          enddo

!---------------------------
      else
!---------------------------

      !---- Edge points

          id0=1
          do ix=0,nx,nx
          do iy=1,nym1
              vel0=vel(ix,iy)
              coef=A1(1,ix,iy)*hx*ht*vel0 *BCcos(iy,id0)
              U2(ix,iy)=( Utilde(ix,iy)-coef*U0(ix,iy)
     &            +htsq*vel0**2*(-AU1(ix,iy)) )/(1.d0-coef)
          enddo
          id0=2
          enddo

          id0=3
          do iy=0,ny,ny
          do ix=1,nxm1
              vel0=vel(ix,iy)
              coef=A2(1,iy,ix)*hy*ht*vel0 *BCcos(ix,id0)
              U2(ix,iy)=( Utilde(ix,iy)-coef*U0(ix,iy)
     &            +htsq*vel0**2*(-AU1(ix,iy)) )/(1.d0-coef)
          enddo
          id0=4
          enddo

          !---- Corner points

          do iy=0,ny,ny
          do ix=0,nx,nx
              vel0=vel(ix,iy)
              coef=A1(1,ix,iy)*hx*ht*vel0
     &            +A2(1,iy,ix)*hy*ht*vel0
              U2(ix,iy)=( Utilde(ix,iy)-coef*U0(ix,iy)
     &            +htsq*vel0**2*(-AU1(ix,iy)) )/(1.d0-coef)
          enddo
          enddo

!---------------------------
      endif
!---------------------------

!---- At the source point

      if(src_Ex .or. src_Ey .or. src_CO) then
          ix=isrcx
          iy=isrcy

          if(src_Ex) then
              vel0=vel(ix,iy)
              coef=A1(1,ix,iy)*hx*ht*vel0
          else if(src_Ey) then
              vel0=vel(ix,iy)
              coef=A2(1,iy,ix)*hy*ht*vel0
          else if(src_CO) then
              vel0=vel(ix,iy)
              coef=A1(1,ix,iy)*hx*ht*vel0
     &            +A2(1,iy,ix)*hy*ht*vel0
          endif

          tmpF=(1.d0-2.d0*theta)*F(n-1)+theta*(F(n-2)+F(n))
          U2(ix,iy)=( Utilde(ix,iy)-coef*U0(ix,iy)
     &        +htsq*vel0**2*(tmpF-AU1(ix,iy)) )/(1.d0-coef)

      endif

      return
      end

