!=======================================================================
      subroutine acoustic2d(nt,nx,ny,mnxy,nVel,nBC,nInit,nSRC,AutoNt,
     &   iOrder,idsol,nb,nwA,level,idnumer,ierr,neqn,
     &   at,bt,ax,bx,ay,by,constDiff,freq,Courant,
     &   theta,freqSol,Obsx,Obsy,
     &   refine,idata,mx,my,DATA,
     &   A1,A2,H,V,U,D,S,F,G,vel,DtVsq,BCcos,wksp)
!=======================================================================
      implicit none
      integer nt,nx,ny,mnxy,nVel,nBC,nInit,nSRC,AutoNt
      integer iOrder,idsol,nb,nwA,level,idnumer,ierr,neqn
      real*8  at,bt,ax,bx,ay,by,constDiff,freq,Courant
      real*8  theta,freqSol,Obsx,Obsy
      real*8  A1(-nb:nb,0:nx,0:ny),A2(-nb:nb,0:ny,0:nx)
      real*8  H(-nb:nb,0:nx,0:ny),V(-nb:nb,0:ny,0:nx)
      real*8  U(0:nx,0:ny,0:2),D(0:nx,0:ny,2),S(0:nx,0:ny)
      real*8  F(0:nt),G(0:nx,0:ny),vel(0:nx,0:ny),DtVsq(0:nx,0:ny)
      real*8  BCcos(0:mnxy,4),wksp(neqn,*)
      integer refine,idata,mx,my
      real*4  DATA(mx,my)

!------------------------------------
!---- local variables
!------------------------------------

      integer i,j,ix,iy,k,level0,level1,levelt,id2,nb1,margin,nt_loc
      real*8  ht,hx,hy,zero,eps,c0,omega,ht_loc
      real*8  px,py,errmax,trueu,pi,tmp
      real*8  velmin,velmax,wlmin,wlmax,hmax
      real*4  utime0,stime0,utime1,stime1
      character*40 scheme

      integer isrcx,isrcy,iObsx,iObsy,ipOut
      logical src_IN,src_Ex,src_Ey,src_CO,Obser

!------------------------------------
!---- basic checking and setting
!------------------------------------

      zero=0.d0
      level0=0
      level1=min(level,1)
      eps=1.d-8
      omega=8.d0*datan(1.d0)*freqSol

      iObsx=nint(dble(nx)*Obsx/100.)
      iObsy=nint(dble(ny)*Obsy/100.)
      if( iObsx.ge.0 .and. iObsx.le.nx .and.
     &    iObsy.ge.0 .and. iObsy.le.ny ) then
          Obser=.TRUE.
      else
          Obser=.FALSE.
      endif

      do k=0,2
      do iy=0,ny
      do ix=0,nx
          U(ix,iy,k)=0.d0
      enddo
      enddo
      enddo

!-----------------

      scheme='NONE'
      if(idsol.eq.1) scheme='Explicit'
      if(idsol.eq.2) scheme='LOD'
      if(idsol.eq.3) scheme='Explicit-Order4'

      if(scheme.eq.'NONE')then
          print*,"**** Error: acoustic2D.f: Wrong idsol"
          ierr=1
          return
      endif

      if(dabs(theta)<eps .and. idsol.eq.2) then
          idsol=1
          scheme='Explicit'
          if(level.ge.1) then
              print*,"---> CHANGE: acoustic2D.f: scheme=",scheme
          endif
      endif

      if(idata.ge.1) then
          if(idnumer.ne.0) then
              idnumer=0
              if(level.ge.1) then
              print*,"---> CHANGE: acoustic2D.f: idnumer=",idnumer
              endif
          endif
      endif

      if(idnumer.ge.1) then
          if(nSRC.ne.0) then
              nSRC=0
              if(level.ge.1) then
              print*,"---> CHANGE: acoustic2D.f: nSRC=",nSRC
              endif
          endif
      endif

!------------------

      if(theta.lt.(-eps) .or. theta.gt.(0.5d0+eps))then
          if(level.ge.1) then
              print*,"---> WARNING: acoustic2D.f: theta=",theta
          endif
      endif

      if( (idsol.eq.1 .or. idsol.eq.3) .and. theta>1.e-5)then
          theta=0.d0
          if(level.ge.1) then
              print*,"---> CHANGE: acoustic2D.f: theta=",theta
          endif
      endif

!-----------------

      if(idnumer.eq.1)then
          if(level.ge.1) then
              print*,"---> WARNING: acoustic2D.f: idnumer=",idnumer
          endif
          tmp=(ax+bx)*0.5d0
          ax=ax-tmp
          bx=bx-tmp
          ay=ax
          by=bx
      endif

      hx=(bx-ax)/dble(nx)
      hy=(by-ay)/dble(ny)
      ht=(bt-at)/dble(nt)

!-----------------------------------------------------------
!---- Read Physical Parameters: U0&G, SRC point, vel, and F
!-----------------------------------------------------------

      call readSRC(nx,ny,nSRC, level1,ierr,ax,bx,ay,by,
     &             isrcx,isrcy,src_IN,src_Ex,src_Ey,src_CO)

      call readVel(nx,ny,nVel,mx,my,refine,idata,level1,ierr,
     &             ax,bx,ay,by,DATA,vel)
      c0=vel(0,0)

      !---------------
      !---- Auto "nt"
      !---------------
      if(AutoNt.ge.1)then
          velmin=1.d5
          velmax=0.d0
          do iy=1,ny,2
          do ix=1,nx,2
             velmin=min(velmin,vel(ix,iy))
             velmax=max(velmax,vel(ix,iy))
          enddo
          enddo
          ht_loc=Courant*(min(hx,hy)/velmax)   ! ht*vel/h <= Courant
          nt_loc=int((bt-at)/ht_loc)+1
          if(nt.lt.nt_loc)then
              print*,"**** Error: acoustic2D.f: nt must >=",nt_loc
              ierr=1
              return
          else
              if(level.ge.1) print*,"---> Auto Dt: Courant=",Courant
          endif
          nt=nt_loc
          ht=(bt-at)/dble(nt)

          if(level.ge.1) then
              wlmin=velmin/freq
              wlmax=velmax/freq
              hmax=max(hx,hy)
              print'("      GF=",f5.2," --",f5.2,
     &              ";  vel=[",f5.2,",",f5.2,"]")',
     &                wlmin/hmax,wlmax/hmax,velmin,velmax
          endif
      endif
      !---------------

      call readU0G(nx,ny,nInit,level1,ierr,ax,bx,ay,by,
     &             c0,omega,idnumer,U(0,0,0),G)

      call getD(nx,ny,level1,ierr,ax,bx,ay,by,
     &          ht,hx,hy,constDiff,D)


!------------------------------------
!---- Print out information
!------------------------------------

      if(level.ge.1)then
         print'("Acoustic2D: idsol=",i2,": ",a40)',idsol,scheme
      endif

      if(level.ge.2)then
         print*,"nt=",nt," at=",at," bt=",bt," ht=",ht
         print*,"nx=",nx," ax=",ax," bx=",bx," hx=",hx
         print*,"ny=",ny," ay=",ay," by=",by," hy=",hy
         print*,"nVel=",nVel," nBC=",nBC," nInit=",nInit," nSRC=",nSRC
         print*,"constDiff=",constDiff," freq=",freq
         print*,"theta=",theta," iOrder=",iOrder," idnumer=",idnumer
         if(Obser)then
         print*,"Obervation @ (",(ax+hx*iObsx),",",(ay+hy*iObsy),")"
         endif
      endif

      if(level.ge.1)then
          open(68,file="fort.U0")
          print*,"<fort.U0> contains computed solution at t=",at
          do j=0,ny
          do i=0,nx
              write(68,*) U(i,j,0)
          enddo
          enddo
          close(68)
      endif


!------------------------------------
!---- Get the Source Terms
!------------------------------------

      if(idnumer.eq.1)then
          call getS(0,nx,ny,nb,level1,ierr,at,ht,theta,
     &              ax,bx,ay,by,c0,omega,S)
      else
          do iy=0,ny
          do ix=0,nx
              S(ix,iy)=0.d0
          enddo
          enddo
      endif

      if(nSRC.eq.0)then
          do k=0,nt
              F(k)=0.d0
          enddo
      else
          pi=4.d0*datan(1.d0)
          do k=0,nt
              tmp=(pi*freq*dble(k)*ht)**2
              tmp=(pi*freq)**2 *(1.d0-2.d0*tmp)*dexp(-tmp)
               ! if(dabs(tmp).lt.(1.d-8)) tmp=0.d0
              F(k)=tmp
          enddo
      endif

      if(ierr.ne.0) return
      call etimef77(utime0,stime0)

!------------------------------------
!---- Get initial values "U1"
!------------------------------------

      nb1=1

      call mtx35Diff(3,nx,ny,nb1,level1,ierr,ax,bx,ay,by,D,A1,A2)
      call getU1(nx,ny,nt,nb1,nBC,isrcx,isrcy,idnumer,level1,ierr,
     &           ax,bx,ay,by,c0,omega,theta, at,ht,hx,hy,
     &           src_IN,src_Ex,src_Ey,src_CO,
     &           vel,F,S,G,A1,A2,U,wksp,wksp(1,4))
      if(ierr.ne.0) return

      ipOut=88
      if(Obser.and.level.ge.1)then
          if(Courant.ge.0.5)then
              if(idsol.eq.1) open(ipOut,file="fort.71")
              if(idsol.eq.2) open(ipOut,file="fort.72")
              if(idsol.eq.3) open(ipOut,file="fort.73")
          else
              if(idsol.eq.1) open(ipOut,file="fort.81")
              if(idsol.eq.2) open(ipOut,file="fort.82")
              if(idsol.eq.3) open(ipOut,file="fort.83")
          endif
          write(ipOut,*) (at),U(iObsx,iObsy,0)
          write(ipOut,*) (at+ht),U(iObsx,iObsy,1)
      endif

!------------------------------------
!---- get "A1" and "A2"
!------------------------------------

      if(nb.ne.nb1)then
          call mtx35Diff(3,nx,ny,nb,level1,ierr,ax,bx,ay,by,D,A1,A2)
          if(ierr.ne.0) return
      endif


!------------------------------------
!---- Call Solvers
!------------------------------------
 1000 continue

      if(idsol.eq.1)then

          call sol_Explicit(nt,nx,ny,idsol,nb,nwA,nBC,level,ierr,
     &        at,bt,ax,bx,ay,by,theta,constDiff,omega,
     &        mnxy,idnumer,isrcx,isrcy,iObsx,iObsy,id2,ipOut,
     &        src_IN,src_Ex,src_Ey,src_CO,Obser,
     &        ht,hx,hy,scheme, A1,A2,H,V,U,D,S,F,vel,
     &        BCcos,wksp(1,1),wksp(1,2))

      else if(idsol.eq.2)then

          call sol_LOD(nt,nx,ny,idsol,nb,nwA,nBC,level,ierr,
     &        at,bt,ax,bx,ay,by,theta,constDiff,omega,
     &        mnxy,idnumer,isrcx,isrcy,iObsx,iObsy,id2,ipOut,
     &        src_IN,src_Ex,src_Ey,src_CO,Obser,
     &        ht,hx,hy,scheme, A1,A2,H,V,U,D,S,F,vel,
     &        BCcos,wksp(1,1),wksp(1,2))

      else if(idsol.eq.3)then

          if(nb.ne.2)then
              print*,"**** Error: acoustic2D.f: Wrong nb or iOrder!!"
              ierr=1
              return
          endif
          call sol_Old_4th(nt,nx,ny,idsol,nb,nwA,nBC,level,ierr,
     &        at,bt,ax,bx,ay,by,theta,constDiff,omega,
     &        mnxy,idnumer,isrcx,isrcy,iObsx,iObsy,id2,ipOut,
     &        src_IN,src_Ex,src_Ey,src_CO,Obser,
     &        ht,hx,hy,scheme, A1,A2,H,V,U,D,S,F,vel,
     &        BCcos,wksp(1,1),wksp(1,2))

      else

          print*,"**** Error: acoustic2D.f: Wrong idsol!!"
          ierr=1
          return

      endif

      if(Obser.and.level.ge.1) close(ipOut)


!------------------------------------
!---- Print out the results
!------------------------------------

      if(level.le.0) return

      print'(40("-"))'
      call etimef77(utime1,stime1)
      print'("Elapsed Time=",f7.2)',utime1-utime0

      print'(" scheme=",a8," theta=",f6.2," freq=",f6.2)',
     &         scheme,theta,freq
      print'(" nt=",i4," at=",f6.2," bt=",f6.2," ht=",f8.4)',nt,at,bt,ht
      print'(" nx=",i4," ax=",f6.2," bx=",f6.2," hx=",f8.4)',nx,ax,bx,hx
      print'(" ny=",i4," ay=",f6.2," by=",f6.2," hy=",f8.4)',ny,ay,by,hy
      if(Obser)then
      print*,"Obervation @ (",(ax+hx*iObsx),",",(ay+hy*iObsy),")"
      endif

      if(idnumer.eq.1 .and. level.ge.1)then
          margin=3
          if(idsol.eq.3 .or. dabs(theta-1.d0/12.d0).le.0.01)then
              margin=(min(nx,ny))/4
          endif
          errmax=0.d0
          do iy=margin,ny-margin
             py=ay+hy*dble(iy)
          do ix=margin,nx-margin
             px=ax+hx*dble(ix)
             tmp=trueu(bt,px,py,bx,c0,omega)
             errmax=max(errmax,dabs(U(ix,iy,id2)-tmp))
          enddo
          enddo
          print'(" L8Err (t=",f5.2,")= ",1pe8.2)',bt,errmax
      endif


      open(1,file="fort.0")
         write(1,*) scheme,idata
      close(1)

      open(1,file="fort.1")
          if(idata.eq.0)then
             write(1,*) nx+1,ax,bx,hx,ny+1,ay,by,hy
          else
             write(1,*) ny+1,ay,by,hy,nx+1,ax,bx,hx
          endif
      close(1)

      open(2,file="fort.2")
         write(2,*) nt,at,bt,ht,theta,freq,theta
      close(2)

      open(3,file="fort.3")
         write(3,'(2(f9.2))') (ax+hx*iObsx),(ay+hy*iObsy)
      close(3)

      open(68,file="fort.Un")
      print*,"<fort.Un> contains computed solution at t=",bt
      if(idata.eq.0)then
          do j=0,ny
          do i=0,nx
              write(68,*) U(i,j,id2)
          enddo
          enddo
      else
          do i=0,nx
          do j=0,ny
              write(68,*) U(i,j,id2)
          enddo
          enddo
      endif
      close(68)

      if(idata.ge.1)then
          open(68,file="fort.Vel")
          print*,"<fort.Vel> contains the velocity"
          do i=0,nx
          do j=0,ny
              write(68,*) vel(i,j)
          enddo
          enddo
          close(68)
      endif


      return
      end
