/***************************/
/* Extra Arrays            */
/***************************/

ATYPE *U,*wksp;
ATYPE *A1,*A2,*H,*V,*D,*S,*F,*G,*vel,*DtVsq,*BCcos;
int nwA,nb,neqn,mnxy,ndwksp;

if(iOrder==4) nb=2;   // fourth-order schemes
else          nb=1;

if(idata>=1 && (mx!=nx || my!=ny)){
   nx=refine*(mx-1); ny=refine*(my-1);
   if(level>=1){
       cout<<" idata="<<idata<<endl;
       cout<<"  nx <-- refine*(mx-1)="<<nx<<endl;
       cout<<"  ny <-- refine*(my-1)="<<ny<<endl;
   }
   ax=0.0; bx=(500.*0.3048/1000.)*(mx-1);
   ay=0.0; by=(500.*0.3048/1000.)*(my-1);
}

nwA=2*nb+1;
neqn=(nx+1)*(ny+1);
mnxy=((nx>ny)?nx:ny);

U  =new ATYPE[neqn*3];   assert(U!=0);
A1 =new ATYPE[nwA*neqn]; assert(A1!=0);
A2 =new ATYPE[nwA*neqn]; assert(A2!=0);
D  =new ATYPE[neqn*2];   assert(D!=0);
F  =new ATYPE[nt+1];     assert(F!=0);
G  =new ATYPE[neqn];     assert(G!=0);
vel=new ATYPE[neqn];     assert(vel!=0);
S  =new ATYPE[neqn*2];   assert(S!=0);
DtVsq=new ATYPE[neqn*2]; assert(DtVsq!=0);

ndwksp=4;  // it must be >= 4.
wksp =new ATYPE[neqn*ndwksp]; assert(wksp!=0);
BCcos=new ATYPE[(mnxy+1)*4];  assert(BCcos!=0);

if(idsol==2){                         // ADI
    H=new ATYPE[nwA*neqn]; assert(H!=0);
    V=new ATYPE[nwA*neqn]; assert(V!=0);
}


/***************************/
/* Call the Driver Routine */
/***************************/

#if defined (_IBMR2) || defined (AIX) || defined (hpux)

   acoustic2d(&nt,&nx,&ny,&mnxy,&nVel,&nBC,&nInit,&nSRC,&AutoNt,
       &iOrder,&idsol,&nb,&nwA,&level,&idnumer,&ierr,&neqn,
       &at,&bt,&ax,&bx,&ay,&by,&constDiff,&freq,&Courant,
       &theta,&freqSol,&Obsx,&Obsy,
       &refine,&idata,&mx,&my,DATA,
       A1,A2,H,V,U,D,S,F,G,vel,DtVsq,BCcos,wksp);

#else

   acoustic2d_(&nt,&nx,&ny,&mnxy,&nVel,&nBC,&nInit,&nSRC,&AutoNt,
       &iOrder,&idsol,&nb,&nwA,&level,&idnumer,&ierr,&neqn,
       &at,&bt,&ax,&bx,&ay,&by,&constDiff,&freq,&Courant,
       &theta,&freqSol,&Obsx,&Obsy,
       &refine,&idata,&mx,&my,DATA,
       A1,A2,H,V,U,D,S,F,G,vel,DtVsq,BCcos,wksp);

#endif

