!=======================================================================
      subroutine rk4step(nt,nx,ny,idsol,level,ht,tn,hx,hy,
     &               K4,x,ierr)
!=======================================================================
      implicit none
      integer nt,nx,ny,idsol,level,ierr
      real*8 ht,tn,hx,hy
      real*8 K4(nx,ny,4),x(nx,ny)

      integer ix,iy,j,jm1
      real*8 ftncu,t,u,jump

      if(level.ge.1) print'("RK4STEP: idsol=",i2)',idsol
      if(level.ge.2) then
         print*,"nt=",nt," nx=",nx," ny=",ny
         print*,"ht=",ht," tn=",tn," hx=",hx," hy=",hy
      endif


      j=0
      t=tn

      do iy=1,ny
      do ix=1,nx
         u=x(ix,iy)
         K4(ix,iy,j)=ht*ftncu(t,u)
      enddo
      enddo


      do j=2,4

         if(j.le.3) then
            jump=0.5d0
         else
            jump=1.0d0
         endif

         t=tn+jump*ht
         jm1=j-1

         do iy=1,ny
         do ix=1,nx
            u=x(ix,iy)+jump*K4(ix,iy,jm1)
            K4(ix,iy,j)=ht*ftncu(t,u)
         enddo
         enddo
      enddo

      return
      end
