c ======================================================================
      subroutine getrhs(nx,ny,level,ax,bx,ay,by,time,src,ierr)
c ======================================================================
      implicit none
      integer nx,ny,level,ierr
      real*8  ax,bx,ay,by,time
      real*8  src(nx,ny)

      integer ix,iy
      real*8  hx,hy,px,py,r2hx,r2hy,ftnf,ftng

      if(level.ge.1) print'("GETRHS: @t=",f9.4)',time
      if(level.ge.3) print*,"nx=",nx," ny=",ny

      hx=(bx-ax)/dble(nx-1)
      hy=(by-ay)/dble(ny-1)
      r2hx=2.d0/hx
      r2hy=2.d0/hy

      do iy=1,ny
         py=hy*dble(iy-1)+ay
      do ix=1,nx
         px=hx*dble(ix-1)+ax
         src(ix,iy)=ftnf(time,px,py)

         if(ix.eq.1) then
            src(ix,iy)=src(ix,iy)+r2hx*ftng(time,px,py,1)
         else if(ix.eq.nx) then
            src(ix,iy)=src(ix,iy)+r2hx*ftng(time,px,py,2)
         endif

         if(iy.eq.1) then
            src(ix,iy)=src(ix,iy)+r2hy*ftng(time,px,py,3)
         else if(iy.eq.ny) then
            src(ix,iy)=src(ix,iy)+r2hy*ftng(time,px,py,4)
         endif

      end do
      end do

      return
      end

