/*************************************/
/*** Main.cpp: generated by CSTART ***/
/*** For details,  skim@ms.uky.edu ***/
/*** Sat Nov 04, 00;   09:19:50 PM ***/
/*************************************/

#include <iostream.h>
#include <assert.h>
#include <math.h>
#define  MAX_LEN 80

typedef  double TYPE;
typedef  double ATYPE;
typedef  double VTYPE;
typedef  float DTYPE;

#include "A.h"

extern "C" void setups(char*setfile,char*infofile,char*datafile,int*nt,int*nx,int*ny,VTYPE*at,VTYPE*bt,VTYPE*ax,VTYPE*bx,VTYPE*ay,VTYPE*by,int*itmax,VTYPE*tol,int*idELL,int*idsol,int*id_nl,int*level,VTYPE*eta,int*maxADI,int*maxGS,int*idSGS,int*maxPCG,int*idsymm,int*idpcond,int*interpol,int*id_hsrc,int*ntrue,int*ndiff,int*nonlin,int*nreact,int*nbc,int*idpsrc,VTYPE*wavet,VTYPE*wavex,VTYPE*wavey,VTYPE*tsbgn,VTYPE*tsend,int*n1,int*n2,int*ierr);

extern "C" void readdata(char*datafile,int n1,int n2,DTYPE*DATA,int level,int*ierr);

main(){
   ATYPE *A,*wksp;
   char  *setfile;
   int   ierr;
   int   narr,nwksp;
   char  infofile[MAX_LEN];
   char  datafile[MAX_LEN];
   int   ndata;
   DTYPE *HEATSRC;
   int   nt;
   int   nx;
   int   ny;
   VTYPE at;
   VTYPE bt;
   VTYPE ax;
   VTYPE bx;
   VTYPE ay;
   VTYPE by;
   int   itmax;
   VTYPE tol;
   int   idELL;
   int   idsol;
   int   id_nl;
   int   level;
   VTYPE eta;
   int   maxADI;
   int   maxGS;
   int   idSGS;
   int   maxPCG;
   int   idsymm;
   int   idpcond;
   int   interpol;
   int   id_hsrc;
   int   ntrue;
   int   ndiff;
   int   nonlin;
   int   nreact;
   int   nbc;
   int   idpsrc;
   VTYPE wavet;
   VTYPE wavex;
   VTYPE wavey;
   VTYPE tsbgn;
   VTYPE tsend;
   int   n1;
   int   n2;

   level=0;
   ierr=0;
   setfile="SET_file";

   /*******************************************************/

   setups(setfile,infofile,datafile,&nt,&nx,&ny,&at,&bt,&ax,&bx,&ay,&by,&itmax,&tol,&idELL,&idsol,&id_nl,&level,&eta,&maxADI,&maxGS,&idSGS,&maxPCG,&idsymm,&idpcond,&interpol,&id_hsrc,&ntrue,&ndiff,&nonlin,&nreact,&nbc,&idpsrc,&wavet,&wavex,&wavey,&tsbgn,&tsend,&n1,&n2,&ierr);

   if(level>=3) cout<<endl;
   if(level>=1) cout<<"MAIN: PROGRAM Heat-Transfer and ADI"<<endl;
   if(level>=2) cout<<" Author: Seongjai Kim"<<endl;
   if(level>=2) cout<<" Date:   Spring 1999"<<endl;
   if(level>=2) cout<<" Comment: idsol; 1:LU; 2:PCG-ILU; 3:ADI; 4:ADI-II; 5:ADI-II-SOR"<<endl;
   if(level>=2) cout<<" Comment: level; set higher when testing"<<endl;
   if(level>=2) cout<<" Comment: idsymm, symmetrize the matrix for idsol:2"<<endl;

   narr=(nx*ny*3)*2;
   nwksp=4*nx*ny;

   A=new ATYPE[narr]; assert(A!= 0);
   wksp=new ATYPE[nwksp]; assert(wksp!= 0); 


   ndata=n1*n2;
   HEATSRC=new DTYPE[ndata]; assert(HEATSRC!= 0);
   readdata(datafile,n1,n2,HEATSRC,level,&ierr);
   if(level>=1)
      cout<<"MAIN: HEATSRC[n1][n2]="<<datafile
          <<"; (n1="<<n1<<" & n2="<<n2<<")"<<endl;


   if(level>=4 || narr==1 || nwksp==1){
      cout<<" ndata="<<ndata<<endl;
      cout<<" narr="<<narr<<" "<<"nwksp="<<nwksp<<endl;
      cout<<" WARNING: You may have to edit for correct array sizes."<<endl;
      }

   /*******************************************************/

   #include "B.h"

   if(level>=1){
      cout<<"MAIN:";
      if(ierr==0) cout<<" Successful computation!!"<<endl;
      else        cout<<" Something is wrong!!"<<endl;
     }

}

